/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.crt.checksums;

import java.util.zip.Checksum;
import software.amazon.awssdk.crt.CRT;

public class CRC64NVME
implements Checksum,
Cloneable {
    private long value = 0L;

    public CRC64NVME() {
    }

    private CRC64NVME(long value) {
        this.value = value;
    }

    public Object clone() {
        return new CRC64NVME(this.value);
    }

    @Override
    public long getValue() {
        return this.value;
    }

    @Override
    public void reset() {
        this.value = 0L;
    }

    @Override
    public void update(byte[] b, int off, int len) {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || off > b.length - len) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.value = CRC64NVME.crc64nvme(b, this.value, off, len);
    }

    @Override
    public void update(byte[] b) {
        this.update(b, 0, b.length);
    }

    @Override
    public void update(int b) {
        if (b < 0 || b > 255) {
            throw new IllegalArgumentException();
        }
        byte[] buf = new byte[]{(byte)(b & 0xFF)};
        this.update(buf);
    }

    private static native long crc64nvme(byte[] var0, long var1, int var3, int var4);

    static {
        new CRT();
    }
}

