/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.pdftk_java;

import com.gitlab.pdftk_java.LoadableInt;
import com.gitlab.pdftk_java.LoadableString;
import com.gitlab.pdftk_java.com.lowagie.text.pdf.PdfDictionary;
import com.gitlab.pdftk_java.com.lowagie.text.pdf.PdfName;
import com.gitlab.pdftk_java.com.lowagie.text.pdf.PdfPageLabels;
import java.util.ArrayList;
import java.util.HashMap;

class PdfPageLabel {
    static final String PREFIX = "PageLabel";
    static final String BEGIN_MARK = "PageLabelBegin";
    static final String NEW_INDEX_LABEL = "PageLabelNewIndex:";
    static final String START_LABEL = "PageLabelStart:";
    static final String PREFIX_LABEL = "PageLabelPrefix:";
    static final String NUM_STYLE_LABEL = "PageLabelNumStyle:";
    int m_new_index = -1;
    int m_start = -1;
    String m_prefix = null;
    String m_num_style = null;

    PdfPageLabel() {
    }

    boolean valid() {
        return this.m_new_index > 0 && this.m_start > 0 && this.m_num_style != null && NumberingStyle.fromString.containsKey(this.m_num_style);
    }

    public String toString() {
        StringBuilder ss = new StringBuilder();
        ss.append(BEGIN_MARK + System.lineSeparator());
        ss.append("PageLabelNewIndex: " + this.m_new_index + System.lineSeparator());
        ss.append("PageLabelStart: " + this.m_start + System.lineSeparator());
        if (this.m_prefix != null) {
            ss.append("PageLabelPrefix: " + this.m_prefix + System.lineSeparator());
        }
        ss.append("PageLabelNumStyle: " + this.m_num_style + System.lineSeparator());
        return ss.toString();
    }

    static PdfDictionary BuildPageLabels(ArrayList<PdfPageLabel> pagelabels_data) {
        PdfPageLabels pagelabels = new PdfPageLabels();
        for (PdfPageLabel pagelabel : pagelabels_data) {
            int num_style = NumberingStyle.fromString.get((Object)pagelabel.m_num_style).value;
            pagelabels.addPageLabel(pagelabel.m_new_index, num_style, pagelabel.m_prefix, pagelabel.m_start);
        }
        return pagelabels.getDictionary();
    }

    boolean loadPrefix(String buff) {
        LoadableString loader = new LoadableString(this.m_prefix);
        boolean success = loader.LoadString(buff, PREFIX_LABEL);
        this.m_prefix = loader.ss;
        return success;
    }

    boolean loadNumStyle(String buff) {
        LoadableString loader = new LoadableString(this.m_num_style);
        boolean success = loader.LoadEnum(buff, NUM_STYLE_LABEL, NumberingStyle.fromString.keySet());
        if (success) {
            this.m_num_style = loader.ss;
        }
        return success;
    }

    boolean loadNewIndex(String buff) {
        LoadableInt loader = new LoadableInt(this.m_new_index);
        boolean success = loader.LoadInt(buff, NEW_INDEX_LABEL);
        this.m_new_index = loader.ii;
        return success;
    }

    boolean loadStart(String buff) {
        LoadableInt loader = new LoadableInt(this.m_start);
        boolean success = loader.LoadInt(buff, START_LABEL);
        this.m_start = loader.ii;
        return success;
    }

    static enum NumberingStyle {
        DECIMAL_ARABIC_NUMERALS(PdfPageLabels.DECIMAL_ARABIC_NUMERALS, "DecimalArabicNumerals", PdfName.D),
        UPPERCASE_ROMAN_NUMERALS(PdfPageLabels.UPPERCASE_ROMAN_NUMERALS, "UppercaseRomanNumerals", PdfName.R),
        LOWERCASE_ROMAN_NUMERALS(PdfPageLabels.LOWERCASE_ROMAN_NUMERALS, "LowercaseRomanNumerals", new PdfName("r")),
        UPPERCASE_LETTERS(PdfPageLabels.UPPERCASE_LETTERS, "UppercaseLetters", PdfName.A),
        LOWERCASE_LETTERS(PdfPageLabels.LOWERCASE_LETTERS, "LowercaseLetters", new PdfName("a")),
        EMPTY(PdfPageLabels.EMPTY, "NoNumber", null),
        ERROR(-1, "[PDFTK ERROR]", null);

        final int value;
        final String representation;
        final PdfName tag;
        static final HashMap<String, NumberingStyle> fromString;
        static final HashMap<PdfName, NumberingStyle> fromPdfName;

        private NumberingStyle(int value, String representation, PdfName tag) {
            this.value = value;
            this.representation = representation;
            this.tag = tag;
        }

        static {
            fromString = new HashMap();
            fromPdfName = new HashMap();
            for (NumberingStyle style : NumberingStyle.values()) {
                fromString.put(style.representation, style);
                fromPdfName.put(style.tag, style);
            }
        }
    }
}

