/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.pdb;

import java.util.Hashtable;
import java.util.Map;
import javajs.util.P3;
import javajs.util.PT;
import org.jmol.adapter.readers.pdb.PdbReader;
import org.jmol.adapter.smarter.Atom;
import org.jmol.util.Logger;
import org.jmol.util.Parser;
import org.jmol.util.Vibration;

public class JmolDataReader
extends PdbReader {
    private Map<String, float[]> props;
    private String[] residueNames;
    private String[] atomNames;
    private boolean isSpin;
    private double spinFactor;
    private int originatingModel = -1;
    private String jmolDataHeader;
    private P3[] jmolDataScaling;

    @Override
    protected void checkRemark() {
        if (this.line.length() >= 30 && this.line.indexOf("Jmol") == 11) {
            switch ("Ppard".indexOf(this.line.substring(16, 17))) {
                case 0: {
                    this.props = new Hashtable<String, float[]>();
                    this.isSpin = this.line.indexOf(": spin;") >= 0;
                    this.originatingModel = -1;
                    int pt = this.line.indexOf("for model ");
                    if (pt > 0) {
                        this.originatingModel = PT.parseInt(this.line.substring(pt + 10));
                    }
                    this.jmolDataHeader = this.line;
                    if (this.line.endsWith("#noautobond")) break;
                    this.line = this.line + "#noautobond";
                    break;
                }
                case 1: {
                    int pt1 = this.line.indexOf("[");
                    int pt2 = this.line.indexOf("]");
                    if (pt1 < 25 || pt2 <= pt1) {
                        return;
                    }
                    String name = this.line.substring(25, pt1).trim();
                    this.line = this.line.substring(pt1 + 1, pt2).replace(',', ' ');
                    String[] tokens = this.getTokens();
                    Logger.info("reading " + name + " " + tokens.length);
                    float[] prop = new float[tokens.length];
                    int i = prop.length;
                    while (--i >= 0) {
                        prop[i] = this.parseFloatStr(tokens[i]);
                    }
                    this.props.put(name, prop);
                    break;
                }
                case 2: {
                    this.line = this.line.substring(27);
                    this.atomNames = this.getTokens();
                    Logger.info("reading atom names " + this.atomNames.length);
                    break;
                }
                case 3: {
                    this.line = this.line.substring(30);
                    this.residueNames = this.getTokens();
                    Logger.info("reading residue names " + this.residueNames.length);
                    break;
                }
                case 4: {
                    Logger.info(this.line);
                    float[] data = new float[15];
                    Parser.parseStringInfestedFloatArray(this.line.substring(10).replace('=', ' ').replace('{', ' ').replace('}', ' '), null, data);
                    P3 minXYZ = P3.new3(data[0], data[1], data[2]);
                    P3 maxXYZ = P3.new3(data[3], data[4], data[5]);
                    this.fileScaling = P3.new3(data[6], data[7], data[8]);
                    this.fileOffset = P3.new3(data[9], data[10], data[11]);
                    P3 plotScale = P3.new3(data[12], data[13], data[14]);
                    if (plotScale.x <= 0.0f) {
                        plotScale.x = 100.0f;
                    }
                    if (plotScale.y <= 0.0f) {
                        plotScale.y = 100.0f;
                    }
                    if (plotScale.z <= 0.0f) {
                        plotScale.z = 100.0f;
                    }
                    if (this.fileScaling.y == 0.0f) {
                        this.fileScaling.y = 1.0f;
                    }
                    if (this.fileScaling.z == 0.0f) {
                        this.fileScaling.z = 1.0f;
                    }
                    if (this.isSpin) {
                        this.spinFactor = plotScale.x / maxXYZ.x;
                    } else {
                        this.setFractionalCoordinates(true);
                        this.latticeCells = new int[4];
                        this.asc.xtalSymmetry = null;
                        this.setUnitCell(plotScale.x * 2.0f / (maxXYZ.x - minXYZ.x), plotScale.y * 2.0f / (maxXYZ.y - minXYZ.y), plotScale.z * 2.0f / (maxXYZ.z == minXYZ.z ? 1.0f : maxXYZ.z - minXYZ.z), 90.0f, 90.0f, 90.0f);
                        this.unitCellOffset = P3.newP(plotScale);
                        this.unitCellOffset.scale(-1.0f);
                        this.getSymmetry();
                        this.symmetry.toFractional(this.unitCellOffset, false);
                        this.unitCellOffset.scaleAdd2(-1.0f, minXYZ, this.unitCellOffset);
                        this.symmetry.setOffsetPt(this.unitCellOffset);
                        this.doApplySymmetry = true;
                    }
                    this.jmolDataScaling = new P3[]{minXYZ, maxXYZ, plotScale};
                }
            }
        }
        this.checkCurrentLineForScript();
    }

    @Override
    protected void processAtom2(Atom atom, int serial, float x, float y, float z, int charge) {
        if (this.isSpin) {
            Vibration vib = new Vibration();
            vib.set(x, y, z);
            vib.isFrom000 = true;
            atom.vib = vib;
            x = (float)((double)x * this.spinFactor);
            y = (float)((double)y * this.spinFactor);
            z = (float)((double)z * this.spinFactor);
        }
        super.processAtom2(atom, serial, x, y, z, charge);
    }

    @Override
    protected void setAdditionalAtomParameters(Atom atom) {
        if (this.residueNames != null && atom.index < this.residueNames.length) {
            atom.group3 = this.residueNames[atom.index];
        }
        if (this.atomNames != null && atom.index < this.atomNames.length) {
            atom.atomName = this.atomNames[atom.index];
        }
    }

    @Override
    protected void finalizeSubclassReader() throws Exception {
        if (this.jmolDataHeader == null) {
            return;
        }
        Hashtable<String, Object> info = new Hashtable<String, Object>();
        info.put("header", this.jmolDataHeader);
        info.put("originatingModel", this.originatingModel);
        info.put("properties", this.props);
        info.put("jmolDataScaling", this.jmolDataScaling);
        this.asc.setInfo("jmolData", info);
        this.finalizeReaderPDB();
    }
}

