/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import kafka.cluster.Partition;
import kafka.server.KafkaConfig;
import kafka.server.QuotaFactory;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaQuota;
import kafka.utils.Logging;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.message.OffsetForLeaderEpochRequestData;
import org.apache.kafka.common.message.OffsetForLeaderEpochResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.BaseRecords;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.RequestUtils;
import org.apache.kafka.server.LeaderEndPoint;
import org.apache.kafka.server.PartitionFetchState;
import org.apache.kafka.server.ReplicaFetch;
import org.apache.kafka.server.ResultWithPartitions;
import org.apache.kafka.server.common.OffsetAndEpoch;
import org.apache.kafka.server.network.BrokerEndPoint;
import org.apache.kafka.server.storage.log.FetchIsolation;
import org.apache.kafka.server.storage.log.FetchParams;
import org.apache.kafka.server.storage.log.FetchPartitionData;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.Set$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0005\tEa\u0001\u0002\u0010 \u0001\u0011B\u0001\"\u0010\u0001\u0003\u0002\u0003\u0006IA\u0010\u0005\t\t\u0002\u0011\t\u0011)A\u0005\u000b\"A\u0011\n\u0001B\u0001B\u0003%!\n\u0003\u0005N\u0001\t\u0005\t\u0015!\u0003O\u0011\u0015\t\u0006\u0001\"\u0001S\u0011\u001dA\u0006A1A\u0005\neCa\u0001\u0019\u0001!\u0002\u0013Q\u0006bB1\u0001\u0005\u0004%IA\u0019\u0005\u0007M\u0002\u0001\u000b\u0011B2\t\u000f\u001d\u0004!\u0019!C\u0005E\"1\u0001\u000e\u0001Q\u0001\n\rDq!\u001b\u0001A\u0002\u0013%!\u000eC\u0004u\u0001\u0001\u0007I\u0011B;\t\rm\u0004\u0001\u0015)\u0003l\u0011\u001da\bA1A\u0005BuDq!a\u0001\u0001A\u0003%a\u0010C\u0004\u0002\u0006\u0001!\t%a\u0002\t\u000f\u0005%\u0001\u0001\"\u0011\u0002\b!9\u00111\u0002\u0001\u0005B\u00055\u0001bBA\b\u0001\u0011\u0005\u0013\u0011\u0003\u0005\b\u0003\u0017\u0002A\u0011IA'\u0011\u001d\t\t\u0007\u0001C!\u0003GBq!!\u001b\u0001\t\u0003\nY\u0007C\u0004\u0002r\u0001!\t%a\u001d\t\u000f\u0005M\u0006\u0001\"\u0011\u00026\"9\u00111\u001b\u0001\u0005\n\u0005U\u0007bBAq\u0001\u0011%\u00111\u001d\u0005\b\u0003W\u0004A\u0011BAw\u0011\u001d\ti\u0010\u0001C!\u0003\u007f\u00141\u0003T8dC2dU-\u00193fe\u0016sG\rU8j]RT!\u0001I\u0011\u0002\rM,'O^3s\u0015\u0005\u0011\u0013!B6bM.\f7\u0001A\n\u0005\u0001\u0015js\u0007\u0005\u0002'W5\tqE\u0003\u0002)S\u0005!A.\u00198h\u0015\u0005Q\u0013\u0001\u00026bm\u0006L!\u0001L\u0014\u0003\r=\u0013'.Z2u!\tqS'D\u00010\u0015\t\u0001\u0003G\u0003\u0002#c)\u0011!gM\u0001\u0007CB\f7\r[3\u000b\u0003Q\n1a\u001c:h\u0013\t1tF\u0001\bMK\u0006$WM]#oIB{\u0017N\u001c;\u0011\u0005aZT\"A\u001d\u000b\u0005i\n\u0013!B;uS2\u001c\u0018B\u0001\u001f:\u0005\u001daunZ4j]\u001e\fAb]8ve\u000e,'I]8lKJ\u0004\"a\u0010\"\u000e\u0003\u0001S!!Q\u0018\u0002\u000f9,Go^8sW&\u00111\t\u0011\u0002\u000f\u0005J|7.\u001a:F]\u0012\u0004v.\u001b8u\u00031\u0011'o\\6fe\u000e{gNZ5h!\t1u)D\u0001 \u0013\tAuDA\u0006LC\u001a\\\u0017mQ8oM&<\u0017A\u0004:fa2L7-Y'b]\u0006<WM\u001d\t\u0003\r.K!\u0001T\u0010\u0003\u001dI+\u0007\u000f\\5dC6\u000bg.Y4fe\u0006)\u0011/^8uCB\u0011aiT\u0005\u0003!~\u0011ABU3qY&\u001c\u0017-U;pi\u0006\fa\u0001P5oSRtD#B*U+Z;\u0006C\u0001$\u0001\u0011\u0015iT\u00011\u0001?\u0011\u0015!U\u00011\u0001F\u0011\u0015IU\u00011\u0001K\u0011\u0015iU\u00011\u0001O\u0003%\u0011X\r\u001d7jG\u0006LE-F\u0001[!\tYf,D\u0001]\u0015\u0005i\u0016!B:dC2\f\u0017BA0]\u0005\rIe\u000e^\u0001\u000be\u0016\u0004H.[2b\u0013\u0012\u0004\u0013\u0001C7bq\nKH/Z:\u0016\u0003\r\u0004\"A\n3\n\u0005\u0015<#aB%oi\u0016<WM]\u0001\n[\u0006D()\u001f;fg\u0002\n\u0011BZ3uG\"\u001c\u0016N_3\u0002\u0015\u0019,Go\u00195TSj,\u0007%A\nj]B\u0013xn\u001a:fgN\u0004\u0016M\u001d;ji&|g.F\u0001l!\rYFN\\\u0005\u0003[r\u0013aa\u00149uS>t\u0007CA8s\u001b\u0005\u0001(BA91\u0003\u0019\u0019w.\\7p]&\u00111\u000f\u001d\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0003]Ig\u000e\u0015:pOJ,7o\u001d)beRLG/[8o?\u0012*\u0017\u000f\u0006\u0002wsB\u00111l^\u0005\u0003qr\u0013A!\u00168ji\"9!0DA\u0001\u0002\u0004Y\u0017a\u0001=%c\u0005!\u0012N\u001c)s_\u001e\u0014Xm]:QCJ$\u0018\u000e^5p]\u0002\nA$[:UeVt7-\u0019;j_:|eNR3uG\"\u001cV\u000f\u001d9peR,G-F\u0001\u007f!\tYv0C\u0002\u0002\u0002q\u0013qAQ8pY\u0016\fg.A\u000fjgR\u0013XO\\2bi&|gn\u00148GKR\u001c\u0007nU;qa>\u0014H/\u001a3!\u00035Ig.\u001b;jCR,7\t\\8tKR\ta/A\u0003dY>\u001cX-\u0001\bce>\\WM]#oIB{\u0017N\u001c;\u0015\u0003y\nQAZ3uG\"$B!a\u0005\u00024A9\u0011QCA\u000e]\u0006}QBAA\f\u0015\r\tI\"K\u0001\u0005kRLG.\u0003\u0003\u0002\u001e\u0005]!aA'baB!\u0011\u0011EA\u0017\u001d\u0011\t\u0019#!\u000b\u000e\u0005\u0005\u0015\"bAA\u0014a\u00069Q.Z:tC\u001e,\u0017\u0002BA\u0016\u0003K\t\u0011CR3uG\"\u0014Vm\u001d9p]N,G)\u0019;b\u0013\u0011\ty#!\r\u0003\u001bA\u000b'\u000f^5uS>tG)\u0019;b\u0015\u0011\tY#!\n\t\u000f\u0005UB\u00031\u0001\u00028\u0005aa-\u001a;dQJ+\u0017/^3tiB!\u0011\u0011HA#\u001d\u0011\tY$!\u0011\u000e\u0005\u0005u\"bAA a\u0006A!/Z9vKN$8/\u0003\u0003\u0002D\u0005u\u0012\u0001\u0004$fi\u000eD'+Z9vKN$\u0018\u0002BA$\u0003\u0013\u0012qAQ;jY\u0012,'O\u0003\u0003\u0002D\u0005u\u0012a\u00054fi\u000eDW)\u0019:mS\u0016\u001cHo\u00144gg\u0016$HCBA(\u00033\ni\u0006\u0005\u0003\u0002R\u0005USBAA*\u0015\t\tx&\u0003\u0003\u0002X\u0005M#AD(gMN,G/\u00118e\u000bB|7\r\u001b\u0005\u0007\u00037*\u0002\u0019\u00018\u0002\u001dQ|\u0007/[2QCJ$\u0018\u000e^5p]\"1\u0011qL\u000bA\u0002i\u000b!cY;se\u0016tG\u000fT3bI\u0016\u0014X\t]8dQ\u0006\tb-\u001a;dQ2\u000bG/Z:u\u001f\u001a47/\u001a;\u0015\r\u0005=\u0013QMA4\u0011\u0019\tYF\u0006a\u0001]\"1\u0011q\f\fA\u0002i\u000b\u0001DZ3uG\",\u0015M\u001d7jKN$Hj\\2bY>3gm]3u)\u0019\ty%!\u001c\u0002p!1\u00111L\fA\u00029Da!a\u0018\u0018\u0001\u0004Q\u0016\u0001\u00064fi\u000eDW\t]8dQ\u0016sGm\u00144gg\u0016$8\u000f\u0006\u0003\u0002v\u0005}\u0005cBA\u000b\u00037q\u0017q\u000f\t\u0005\u0003s\nIJ\u0004\u0003\u0002|\u0005Ue\u0002BA?\u0003'sA!a \u0002\u0012:!\u0011\u0011QAH\u001d\u0011\t\u0019)!$\u000f\t\u0005\u0015\u00151R\u0007\u0003\u0003\u000fS1!!#$\u0003\u0019a$o\\8u}%\tA'\u0003\u00023g%\u0011!%M\u0005\u0003cBJ1!a\nq\u0013\u0011\t9*!\n\u0002A=3gm]3u\r>\u0014H*Z1eKJ,\u0005o\\2i%\u0016\u001c\bo\u001c8tK\u0012\u000bG/Y\u0005\u0005\u00037\u000biJ\u0001\bFa>\u001c\u0007.\u00128e\u001f\u001a47/\u001a;\u000b\t\u0005]\u0015Q\u0005\u0005\b\u0003CC\u0002\u0019AAR\u0003)\u0001\u0018M\u001d;ji&|gn\u001d\t\b\u0003+\tYB\\AS!\u0011\t9+!,\u000f\t\u0005\r\u0012\u0011V\u0005\u0005\u0003W\u000b)#A\u0010PM\u001a\u001cX\r\u001e$pe2+\u0017\rZ3s\u000bB|7\r\u001b*fcV,7\u000f\u001e#bi\u0006LA!a,\u00022\nArJ\u001a4tKR4uN\u001d'fC\u0012,'\u000fU1si&$\u0018n\u001c8\u000b\t\u0005-\u0016QE\u0001\u000bEVLG\u000e\u001a$fi\u000eDG\u0003BA\\\u0003\u0013\u0004RALA]\u0003{K1!a/0\u0005Q\u0011Vm];mi^KG\u000f\u001b)beRLG/[8ogB1\u0011QCA`\u0003\u0007LA!!1\u0002\u0018\tAq\n\u001d;j_:\fG\u000eE\u0002/\u0003\u000bL1!a20\u00051\u0011V\r\u001d7jG\u00064U\r^2i\u0011\u001d\t\t+\u0007a\u0001\u0003\u0017\u0004r!!\u0006\u0002\u001c9\fi\rE\u0002/\u0003\u001fL1!!50\u0005M\u0001\u0016M\u001d;ji&|gNR3uG\"\u001cF/\u0019;f\u0003Y\u0019X\r\\3diB\u000b'\u000f^5uS>tGk\u001c$fi\u000eDG\u0003BAl\u0003?\u0004b!!\u0006\u0002@\u0006e\u0007CB.\u0002\\:\fi-C\u0002\u0002^r\u0013a\u0001V;qY\u0016\u0014\u0004bBAQ5\u0001\u0007\u00111Z\u0001\u0017EVLG\u000e\u001a$fi\u000eDgi\u001c:QCJ$\u0018\u000e^5p]R1\u0011qWAs\u0003ODa!a\u0017\u001c\u0001\u0004q\u0007bBAu7\u0001\u0007\u0011QZ\u0001\u000bM\u0016$8\r[*uCR,\u0017A\u00058fqR\u0014V-\u00193z!\u0006\u0014H/\u001b;j_:$B!a<\u0002rB!1\f\\Am\u0011\u001d\t\t\u000b\ba\u0001\u0003g\u0004r!!>\u0002|:\fi-\u0004\u0002\u0002x*\u0019\u0011\u0011 /\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002\u001e\u0005]\u0018\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\t\u0005\u0001\u0003\u0002B\u0002\u0005\u0017qAA!\u0002\u0003\bA\u0019\u0011Q\u0011/\n\u0007\t%A,\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0005\u001b\u0011yA\u0001\u0004TiJLgn\u001a\u0006\u0004\u0005\u0013a\u0006")
public class LocalLeaderEndPoint
implements LeaderEndPoint,
Logging {
    private final BrokerEndPoint sourceBroker;
    private final ReplicaManager replicaManager;
    private final ReplicaQuota quota;
    private final int replicaId;
    private final Integer maxBytes;
    private final Integer fetchSize;
    private Option<TopicPartition> inProgressPartition;
    private final boolean isTruncationOnFetchSupported;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private int replicaId() {
        return this.replicaId;
    }

    private Integer maxBytes() {
        return this.maxBytes;
    }

    private Integer fetchSize() {
        return this.fetchSize;
    }

    private Option<TopicPartition> inProgressPartition() {
        return this.inProgressPartition;
    }

    private void inProgressPartition_$eq(Option<TopicPartition> x$1) {
        this.inProgressPartition = x$1;
    }

    public boolean isTruncationOnFetchSupported() {
        return this.isTruncationOnFetchSupported;
    }

    public void initiateClose() {
    }

    public void close() {
    }

    public BrokerEndPoint brokerEndPoint() {
        return this.sourceBroker;
    }

    public java.util.Map<TopicPartition, FetchResponseData.PartitionData> fetch(FetchRequest.Builder fetchRequest) {
        ObjectRef partitionData = ObjectRef.create(null);
        FetchRequest request = (FetchRequest)fetchRequest.build();
        HashMap topicNames = new HashMap();
        request.data().topics().forEach(topic -> topicNames.put((Object)topic.topicId(), (Object)topic.topic()));
        java.util.Map fetchData = request.fetchData(CollectionConverters$.MODULE$.MutableMapHasAsJava((scala.collection.mutable.Map)topicNames).asJava());
        FetchParams fetchParams = new FetchParams(-3, -1L, 0L, request.minBytes(), request.maxBytes(), FetchIsolation.LOG_END, Optional.empty());
        this.replicaManager.fetchMessages(fetchParams, (Seq<Tuple2<TopicIdPartition, FetchRequest.PartitionData>>)CollectionConverters$.MODULE$.MapHasAsScala(fetchData).asScala().toSeq(), QuotaFactory.UNBOUNDED_QUOTA, (Function1<Seq<Tuple2<TopicIdPartition, FetchPartitionData>>, BoxedUnit>)(Function1 & Serializable)responsePartitionData -> {
            LocalLeaderEndPoint.processResponseCallback$1(responsePartitionData, partitionData);
            return BoxedUnit.UNIT;
        });
        if ((Seq)partitionData.elem == null) {
            throw new IllegalStateException("Failed to fetch data for partitions " + Predef$.MODULE$.wrapRefArray(fetchData.keySet().toArray()).mkString(","));
        }
        return CollectionConverters$.MODULE$.MapHasAsJava((Map)((Seq)partitionData.elem).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())).asJava();
    }

    public OffsetAndEpoch fetchEarliestOffset(TopicPartition topicPartition, int currentLeaderEpoch) {
        Partition partition = this.replicaManager.getPartitionOrException(topicPartition);
        long logStartOffset = partition.localLogOrException().logStartOffset();
        OptionalInt epoch = partition.localLogOrException().leaderEpochCache().epochForOffset(logStartOffset);
        return new OffsetAndEpoch(logStartOffset, epoch.orElse(0));
    }

    public OffsetAndEpoch fetchLatestOffset(TopicPartition topicPartition, int currentLeaderEpoch) {
        Partition partition = this.replicaManager.getPartitionOrException(topicPartition);
        long logEndOffset = partition.localLogOrException().logEndOffset();
        OptionalInt epoch = partition.localLogOrException().leaderEpochCache().epochForOffset(logEndOffset);
        return new OffsetAndEpoch(logEndOffset, epoch.orElse(0));
    }

    public OffsetAndEpoch fetchEarliestLocalOffset(TopicPartition topicPartition, int currentLeaderEpoch) {
        Partition partition = this.replicaManager.getPartitionOrException(topicPartition);
        long localLogStartOffset = partition.localLogOrException().localLogStartOffset();
        OptionalInt epoch = partition.localLogOrException().leaderEpochCache().epochForOffset(localLogStartOffset);
        return new OffsetAndEpoch(localLogStartOffset, epoch.orElse(0));
    }

    public java.util.Map<TopicPartition, OffsetForLeaderEpochResponseData.EpochEndOffset> fetchEpochEndOffsets(java.util.Map<TopicPartition, OffsetForLeaderEpochRequestData.OffsetForLeaderPartition> partitions) {
        return CollectionConverters$.MODULE$.MutableMapHasAsJava((scala.collection.mutable.Map)CollectionConverters$.MODULE$.MapHasAsScala(partitions).asScala().map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                TopicPartition tp = (TopicPartition)x0$1._1();
                OffsetForLeaderEpochRequestData.OffsetForLeaderPartition epochData = (OffsetForLeaderEpochRequestData.OffsetForLeaderPartition)x0$1._2();
                try {
                    OffsetForLeaderEpochResponseData.EpochEndOffset endOffset = epochData.leaderEpoch() == -1 ? new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(tp.partition()).setErrorCode(Errors.NONE.code()) : $this.replicaManager.getPartitionOrException(tp).lastOffsetForLeaderEpoch(RequestUtils.getLeaderEpoch((int)epochData.currentLeaderEpoch()), epochData.leaderEpoch(), false);
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)endOffset);
                }
                catch (Throwable t) {
                    this.warn((Function0<String>)(Function0 & Serializable)() -> "Error when getting EpochEndOffset for " + tp, (Function0<Throwable>)(Function0 & Serializable)() -> t);
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(tp.partition()).setErrorCode(Errors.forException((Throwable)t).code()));
                }
            }
            throw new MatchError(null);
        })).asJava();
    }

    /*
     * WARNING - void declaration
     */
    public ResultWithPartitions<Optional<ReplicaFetch>> buildFetch(java.util.Map<TopicPartition, PartitionFetchState> partitions) {
        if (this.quota.isQuotaExceeded()) {
            return new ResultWithPartitions(Optional.empty(), Set.of());
        }
        Optional<Tuple2<TopicPartition, PartitionFetchState>> selectPartition = this.selectPartitionToFetch(partitions);
        if (selectPartition.isPresent()) {
            void var5_5;
            void var4_4;
            Tuple2<TopicPartition, PartitionFetchState> tuple2 = selectPartition.get();
            if (tuple2 == null) {
                throw new MatchError(null);
            }
            TopicPartition tp = (TopicPartition)tuple2._1();
            PartitionFetchState fetchState = (PartitionFetchState)tuple2._2();
            return this.buildFetchForPartition((TopicPartition)var4_4, (PartitionFetchState)var5_5);
        }
        return new ResultWithPartitions(Optional.empty(), Set.of());
    }

    private Optional<Tuple2<TopicPartition, PartitionFetchState>> selectPartitionToFetch(java.util.Map<TopicPartition, PartitionFetchState> partitions) {
        Optional<Tuple2<TopicPartition, PartitionFetchState>> optional;
        block5: {
            Object object = new Object();
            try {
                Tuple2 tuple2;
                this.inProgressPartition().foreach((Function1 & Serializable)tp -> {
                    LocalLeaderEndPoint.$anonfun$selectPartitionToFetch$1(partitions, object, tp);
                    return BoxedUnit.UNIT;
                });
                this.inProgressPartition_$eq((Option<TopicPartition>)None$.MODULE$);
                Option<Tuple2<TopicPartition, PartitionFetchState>> nextPartitionOpt = this.nextReadyPartition((Map<TopicPartition, PartitionFetchState>)CollectionConverters$.MODULE$.MapHasAsScala(partitions).asScala().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
                nextPartitionOpt.foreach((Function1 & Serializable)x0$1 -> {
                    LocalLeaderEndPoint.$anonfun$selectPartitionToFetch$4(this, partitions, x0$1);
                    return BoxedUnit.UNIT;
                });
                if (nextPartitionOpt instanceof Some && (tuple2 = (Tuple2)((Some)nextPartitionOpt).value()) != null) {
                    TopicPartition tp2 = (TopicPartition)tuple2._1();
                    PartitionFetchState fetchState = (PartitionFetchState)tuple2._2();
                    optional = Optional.of(new Tuple2((Object)tp2, (Object)fetchState));
                    break block5;
                }
                if (None$.MODULE$.equals(nextPartitionOpt)) {
                    optional = Optional.empty();
                    break block5;
                }
                throw new MatchError(nextPartitionOpt);
            }
            catch (NonLocalReturnControl ex) {
                if (ex.key() == object) {
                    return (Optional)ex.value();
                }
                throw ex;
            }
        }
        return optional;
    }

    /*
     * WARNING - void declaration
     */
    private ResultWithPartitions<Optional<ReplicaFetch>> buildFetchForPartition(TopicPartition topicPartition, PartitionFetchState fetchState) {
        Optional<Object> optional;
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> requestMap = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        scala.collection.mutable.Set partitionsWithError = (scala.collection.mutable.Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        try {
            long logStartOffset = this.replicaManager.futureLocalLogOrException(topicPartition).logStartOffset();
            Optional lastFetchedEpoch = this.isTruncationOnFetchSupported() ? fetchState.lastFetchedEpoch() : Optional.empty();
            Uuid topicId = fetchState.topicId().orElse(Uuid.ZERO_UUID);
            requestMap.put(topicPartition, new FetchRequest.PartitionData(topicId, fetchState.fetchOffset(), logStartOffset, Predef$.MODULE$.Integer2int(this.fetchSize()), Optional.of(Predef$.MODULE$.int2Integer(fetchState.currentLeaderEpoch())), lastFetchedEpoch));
        }
        catch (KafkaStorageException e) {
            this.debug((Function0<String>)(Function0 & Serializable)() -> "Failed to build fetch for " + topicPartition, (Function0<Throwable>)(Function0 & Serializable)() -> e);
            partitionsWithError.$plus$eq((Object)topicPartition);
        }
        if (requestMap.isEmpty()) {
            optional = Optional.empty();
        } else {
            void forReplica_minBytes;
            void forReplica_maxWait;
            void forReplica_replicaEpoch;
            short version = fetchState.topicId().isEmpty() ? (short)12 : (short)ApiKeys.FETCH.latestVersion();
            boolean bl = false;
            boolean bl2 = false;
            long l = -1L;
            int forReplica_replicaId = this.replicaId();
            FetchRequest.Builder requestBuilder = new FetchRequest.Builder(version, version, forReplica_replicaId, (long)forReplica_replicaEpoch, (int)forReplica_maxWait, (int)forReplica_minBytes, requestMap).setMaxBytes(Predef$.MODULE$.Integer2int(this.maxBytes()));
            optional = Optional.of(new ReplicaFetch(requestMap, requestBuilder));
        }
        Optional fetchRequestOpt = optional;
        return new ResultWithPartitions(fetchRequestOpt, CollectionConverters$.MODULE$.MutableSetHasAsJava(partitionsWithError).asJava());
    }

    private Option<Tuple2<TopicPartition, PartitionFetchState>> nextReadyPartition(Map<TopicPartition, PartitionFetchState> partitions) {
        return ((IterableOnceOps)partitions.filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)LocalLeaderEndPoint.$anonfun$nextReadyPartition$1(x0$1)))).reduceLeftOption((Function2 & Serializable)(left, right) -> {
            block3: {
                block2: {
                    if (StringOps$.MODULE$.$less$extension(Predef$.MODULE$.augmentString(((TopicPartition)left._1()).topic()), ((TopicPartition)right._1()).topic())) break block2;
                    String string = ((TopicPartition)left._1()).topic();
                    String string2 = ((TopicPartition)right._1()).topic();
                    if ((string != null ? !string.equals(string2) : string2 != null) || ((TopicPartition)left._1()).partition() >= ((TopicPartition)right._1()).partition()) break block3;
                }
                return left;
            }
            return right;
        });
    }

    public String toString() {
        return "LocalLeaderEndPoint";
    }

    private static final void processResponseCallback$1(Seq responsePartitionData, ObjectRef partitionData$1) {
        partitionData$1.elem = (Seq)responsePartitionData.map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                TopicIdPartition tp = (TopicIdPartition)x0$1._1();
                FetchPartitionData data = (FetchPartitionData)x0$1._2();
                List abortedTransactions = data.abortedTransactions.orElse(null);
                long lastStableOffset = data.lastStableOffset.orElse(-1L);
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp.topicPartition()), (Object)new FetchResponseData.PartitionData().setPartitionIndex(tp.topicPartition().partition()).setErrorCode(data.error.code()).setHighWatermark(data.highWatermark).setLastStableOffset(lastStableOffset).setLogStartOffset(data.logStartOffset).setAbortedTransactions(abortedTransactions).setRecords((BaseRecords)data.records));
            }
            throw new MatchError(null);
        });
    }

    public static final /* synthetic */ void $anonfun$selectPartitionToFetch$1(java.util.Map partitions$1, Object nonLocalReturnKey1$1, TopicPartition tp) {
        Option$.MODULE$.apply(partitions$1.get(tp)).filter((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.isReadyForFetch())).foreach((Function1 & Serializable)fetchState -> {
            throw new NonLocalReturnControl(nonLocalReturnKey1$1, Optional.of(new Tuple2((Object)tp, fetchState)));
        });
    }

    public static final /* synthetic */ void $anonfun$selectPartitionToFetch$4(LocalLeaderEndPoint $this, java.util.Map partitions$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            TopicPartition tp = (TopicPartition)x0$1._1();
            PartitionFetchState fetchState = (PartitionFetchState)x0$1._2();
            $this.inProgressPartition_$eq((Option<TopicPartition>)new Some((Object)tp));
            $this.info((Function0<String>)(Function0 & Serializable)() -> "Beginning/resuming copy of partition " + tp + " from offset " + fetchState.fetchOffset() + ". Including this partition, there are " + partitions$1.size() + " remaining partitions to copy by this thread.");
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$nextReadyPartition$1(Tuple2 x0$1) {
        if (x0$1 != null) {
            return ((PartitionFetchState)x0$1._2()).isReadyForFetch();
        }
        throw new MatchError(null);
    }

    public LocalLeaderEndPoint(BrokerEndPoint sourceBroker, KafkaConfig brokerConfig, ReplicaManager replicaManager, ReplicaQuota quota) {
        this.sourceBroker = sourceBroker;
        this.replicaManager = replicaManager;
        this.quota = quota;
        this.replicaId = brokerConfig.brokerId();
        this.maxBytes = brokerConfig.replicaFetchResponseMaxBytes();
        this.fetchSize = brokerConfig.replicaFetchMaxBytes();
        this.inProgressPartition = None$.MODULE$;
        this.isTruncationOnFetchSupported = false;
    }
}

