/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devservices.crossclassloader.runtime;

import io.quarkus.devservices.crossclassloader.runtime.ComparableDevServicesConfig;
import io.quarkus.devservices.crossclassloader.runtime.DevServiceOwner;
import io.quarkus.devservices.crossclassloader.runtime.RunningService;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.logging.Logger;

public final class RunningDevServicesRegistry {
    private static final Logger log = Logger.getLogger(RunningDevServicesRegistry.class);
    public static final RunningDevServicesRegistry INSTANCE = new RunningDevServicesRegistry();
    public static final String APPLICATION_UUID = UUID.randomUUID().toString();
    private static final Map<String, Set<RunningService>> servicesIndexedByLaunchMode = new ConcurrentHashMap<String, Set<RunningService>>();
    private final Map<ComparableDevServicesConfig, RunningService> servicesIndexedByConfig = new ConcurrentHashMap<ComparableDevServicesConfig, RunningService>();

    private RunningDevServicesRegistry() {
    }

    void logClosing(String featureName, String launchMode, String containerId) {
        log.debugf("Closing dev service for %s in launch mode %s: %s", (Object)featureName, (Object)launchMode, (Object)containerId);
    }

    void logFailedToClose(Exception e, String featureName, String launchMode, String containerId) {
        log.infof((Throwable)e, "Failed to close dev service for %s in launch mode %s: %s", (Object)featureName, (Object)launchMode, (Object)containerId);
    }

    public void closeAllRunningServices(String launchMode) {
        Iterator<Map.Entry<ComparableDevServicesConfig, RunningService>> it = this.servicesIndexedByConfig.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<ComparableDevServicesConfig, RunningService> next = it.next();
            DevServiceOwner owner = next.getKey().owner();
            if (!owner.launchMode().equals(launchMode)) continue;
            it.remove();
            RunningService service = next.getValue();
            try {
                this.logClosing(owner.featureName(), launchMode, service.containerId());
                service.close();
            }
            catch (Exception e) {
                this.logFailedToClose(e, owner.featureName(), launchMode, service.containerId());
            }
        }
        servicesIndexedByLaunchMode.remove(launchMode);
    }

    public void closeRemainingRunningServices(UUID uuid, String launchMode, Collection<DevServiceOwner> ownersToKeep) {
        Set<RunningService> services = servicesIndexedByLaunchMode.get(launchMode);
        Iterator<Map.Entry<ComparableDevServicesConfig, RunningService>> iterator = this.servicesIndexedByConfig.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<ComparableDevServicesConfig, RunningService> entry = iterator.next();
            DevServiceOwner owner = entry.getKey().owner();
            UUID serviceAppUuid = entry.getKey().applicationInstanceId();
            if (!owner.launchMode().equals(launchMode) || !Objects.equals(serviceAppUuid, uuid) || ownersToKeep.contains(owner)) continue;
            iterator.remove();
            RunningService service = entry.getValue();
            services.remove(service);
            try {
                this.logClosing(owner.featureName(), launchMode, service.containerId());
                service.close();
            }
            catch (Exception e) {
                this.logFailedToClose(e, owner.featureName(), launchMode, service.containerId());
            }
        }
    }

    public void closeAllRunningServices(DevServiceOwner owner) {
        Set<RunningService> launchModeServices = servicesIndexedByLaunchMode.get(owner.launchMode());
        Iterator<Map.Entry<ComparableDevServicesConfig, RunningService>> iterator = this.servicesIndexedByConfig.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<ComparableDevServicesConfig, RunningService> entry = iterator.next();
            DevServiceOwner entryOwner = entry.getKey().owner();
            if (!Objects.equals(entryOwner, owner)) continue;
            iterator.remove();
            RunningService service = entry.getValue();
            if (launchModeServices != null) {
                launchModeServices.remove(service);
            }
            try {
                this.logClosing(owner.featureName(), owner.featureName(), service.containerId());
                service.close();
            }
            catch (Exception e) {
                this.logFailedToClose(e, owner.featureName(), owner.launchMode(), service.containerId());
            }
        }
    }

    public Set<RunningService> getAllRunningServices(String launchMode) {
        return servicesIndexedByLaunchMode.getOrDefault(launchMode, Collections.emptySet());
    }

    public RunningService getRunningServices(ComparableDevServicesConfig identifyingConfig) {
        return this.servicesIndexedByConfig.get(identifyingConfig);
    }

    public void addRunningService(ComparableDevServicesConfig key, RunningService service) {
        this.servicesIndexedByConfig.put(key, service);
        servicesIndexedByLaunchMode.computeIfAbsent(key.owner().launchMode(), k -> new HashSet()).add(service);
    }
}

