/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators.uni;

import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.operators.AbstractUni;
import io.smallrye.mutiny.operators.UniOperator;
import io.smallrye.mutiny.operators.uni.UniOperatorProcessor;
import io.smallrye.mutiny.subscription.UniSubscriber;
import java.time.Duration;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class UniDelayOnItem<T>
extends UniOperator<T, T> {
    private final Duration duration;
    private final ScheduledExecutorService executor;

    public UniDelayOnItem(Uni<T> upstream, Duration duration, ScheduledExecutorService executor) {
        super(ParameterValidation.nonNull(upstream, "upstream"));
        this.duration = ParameterValidation.validate(duration, "duration");
        this.executor = ParameterValidation.nonNull(executor, "executor");
    }

    @Override
    public void subscribe(UniSubscriber<? super T> subscriber) {
        AbstractUni.subscribe(this.upstream(), new UniDelayOnItemProcessor(subscriber));
    }

    private class UniDelayOnItemProcessor
    extends UniOperatorProcessor<T, T> {
        private volatile ScheduledFuture<?> scheduledFuture;

        public UniDelayOnItemProcessor(UniSubscriber<? super T> downstream) {
            super(downstream);
        }

        @Override
        public void cancel() {
            if (!this.isCancelled()) {
                super.cancel();
                if (this.scheduledFuture != null) {
                    this.scheduledFuture.cancel(false);
                }
            }
        }

        @Override
        public void onItem(T item) {
            if (!this.isCancelled()) {
                try {
                    Runnable dispatch = () -> this.downstream.onItem(item);
                    this.scheduledFuture = UniDelayOnItem.this.executor.schedule(dispatch, UniDelayOnItem.this.duration.toMillis(), TimeUnit.MILLISECONDS);
                }
                catch (Throwable err) {
                    this.downstream.onFailure(err);
                }
            }
        }
    }
}

