/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.model;

public class DataType {
    public final Type type;
    public final DataType content;
    public final Class<?> clazz;

    private DataType(Type type, DataType content, Class<?> clazz) {
        this.type = type;
        this.content = content;
        this.clazz = clazz;
    }

    public static DataType type(Class<?> clazz) {
        return new DataType(Type.OBJECT, null, clazz);
    }

    public static DataType listOf(DataType content) {
        return new DataType(Type.LIST, content, null);
    }

    public static DataType mapOf(DataType content) {
        return new DataType(Type.MAP, content, null);
    }

    public String toString() {
        switch (this.type.ordinal()) {
            case 1: {
                return "list of [" + this.content.toString() + "]";
            }
            case 2: {
                return "map of [" + this.content.toString() + "]";
            }
        }
        return this.clazz.getName();
    }

    public static enum Type {
        OBJECT,
        LIST,
        MAP;

    }
}

