/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.runtime.graal;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.graalvm.nativeimage.hosted.Feature;

public class DisableLoggingFeature
implements Feature {
    private static final String[] WARN_CATEGORIES = new String[]{"org.jboss.threads"};
    private static final String[] ERROR_CATEGORIES = new String[]{"io.netty.resolver.dns.DnsServerAddressStreamProviders"};
    private final Map<String, Level> categoryMap = new HashMap<String, Level>(WARN_CATEGORIES.length + ERROR_CATEGORIES.length);

    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        Logger logger;
        for (String category : WARN_CATEGORIES) {
            logger = Logger.getLogger(category);
            this.categoryMap.put(category, logger.getLevel());
            logger.setLevel(Level.WARNING);
        }
        for (String category : ERROR_CATEGORIES) {
            logger = Logger.getLogger(category);
            this.categoryMap.put(category, logger.getLevel());
            logger.setLevel(Level.SEVERE);
        }
    }

    public void afterAnalysis(Feature.AfterAnalysisAccess access) {
        for (Map.Entry<String, Level> entry : this.categoryMap.entrySet()) {
            Logger logger = Logger.getLogger(entry.getKey());
            logger.setLevel(entry.getValue());
        }
        this.categoryMap.clear();
    }

    public String getDescription() {
        return "Adapts logging during the analysis phase";
    }
}

