/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.jdbc.mutation.internal;

import java.util.function.BiConsumer;
import java.util.function.Predicate;
import org.hibernate.engine.jdbc.mutation.group.PreparedStatementDetails;
import org.hibernate.engine.jdbc.mutation.internal.AbstractPreparedStatementGroup;
import org.hibernate.engine.jdbc.mutation.internal.ModelMutationHelper;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.generator.values.GeneratedValuesMutationDelegate;
import org.hibernate.sql.model.PreparableMutationOperation;
import org.hibernate.sql.model.TableMapping;

public class PreparedStatementGroupSingleTable
extends AbstractPreparedStatementGroup {
    private final PreparableMutationOperation jdbcMutation;
    private final PreparedStatementDetails statementDetails;

    public PreparedStatementGroupSingleTable(PreparableMutationOperation jdbcMutation, SharedSessionContractImplementor session) {
        this(jdbcMutation, null, session);
    }

    public PreparedStatementGroupSingleTable(PreparableMutationOperation jdbcMutation, GeneratedValuesMutationDelegate delegate, SharedSessionContractImplementor session) {
        super(session);
        this.jdbcMutation = jdbcMutation;
        this.statementDetails = ModelMutationHelper.standardPreparation(jdbcMutation, delegate, session);
    }

    protected TableMapping getMutatingTableDetails() {
        return this.jdbcMutation.getTableDetails();
    }

    @Override
    public int getNumberOfStatements() {
        return 1;
    }

    @Override
    public int getNumberOfActiveStatements() {
        return this.statementDetails.getStatement() == null ? 0 : 1;
    }

    @Override
    public PreparedStatementDetails getSingleStatementDetails() {
        return this.statementDetails;
    }

    @Override
    public void forEachStatement(BiConsumer<String, PreparedStatementDetails> action) {
        action.accept(this.getMutatingTableDetails().getTableName(), this.statementDetails);
    }

    @Override
    public PreparedStatementDetails getPreparedStatementDetails(String tableName) {
        if (this.statementDetails == null) {
            return null;
        }
        assert (this.getMutatingTableDetails().getTableName().equals(tableName));
        return this.statementDetails;
    }

    @Override
    public PreparedStatementDetails resolvePreparedStatementDetails(String tableName) {
        assert (this.getMutatingTableDetails().getTableName().equals(tableName));
        return this.statementDetails;
    }

    @Override
    public boolean hasMatching(Predicate<PreparedStatementDetails> filter) {
        return filter.test(this.statementDetails);
    }

    @Override
    public void release() {
        if (this.statementDetails != null) {
            this.release(this.statementDetails);
        }
    }
}

