/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ArchitectureType {
    I386("i386"),
    X86_64("x86_64"),
    ARM64("arm64"),
    X86_64_MAC("x86_64_mac"),
    ARM64_MAC("arm64_mac"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ArchitectureType> VALUE_MAP;
    private final String value;

    private ArchitectureType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ArchitectureType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ArchitectureType> knownValues() {
        EnumSet<ArchitectureType> knownValues = EnumSet.allOf(ArchitectureType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ArchitectureType.class, ArchitectureType::toString);
    }
}

