/*=========================================================================
*
*  Copyright NumFOCUS
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*         http://www.apache.org/licenses/LICENSE-2.0.txt
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*
*=========================================================================*/
#ifndef sitkNormalizedCorrelationImageFilter_h
#define sitkNormalizedCorrelationImageFilter_h

/*
 * WARNING: DO NOT EDIT THIS FILE!
 * THIS FILE IS AUTOMATICALLY GENERATED BY THE SIMPLEITK BUILD PROCESS.
 * Please look at sitkImageFilterTemplate.h.in to make changes.
 */

#include <memory>

#include "sitkBasicFilters.h"
#include "sitkImageFilter.h"

namespace itk::simple {

    /**\class NormalizedCorrelationImageFilter
\brief Computes the normalized correlation of an image and a template.

This filter calculates the normalized correlation between an image and the template. Normalized correlation is frequently use in feature detection because it is invariant to local changes in contrast.

The filter can be given a mask. When presented with an input image and a mask, the normalized correlation is only calculated at those pixels under the mask.

\see Image 


\see Neighborhood 


\see NeighborhoodOperator 


\see NeighborhoodIterator
\sa itk::simple::NormalizedCorrelation for the procedural interface
\sa itk::NormalizedCorrelationImageFilter for the Doxygen on the original ITK class.
     */
    class SITKBasicFilters_EXPORT NormalizedCorrelationImageFilter : public ImageFilter {
    public:
      using Self = NormalizedCorrelationImageFilter;

      /** Destructor */
      virtual ~NormalizedCorrelationImageFilter();

      /** Default Constructor that takes no arguments and initializes
       * default parameters */
      NormalizedCorrelationImageFilter();

      /** Define the pixels types supported by this filter */
      using PixelIDTypeList = BasicPixelIDTypeList;


      /** Name of this class */
      std::string GetName() const { return std::string ("NormalizedCorrelationImageFilter"); }

      /** Print ourselves out */
      std::string ToString() const;


      /** Execute the filter on the input image */

      Image Execute ( const Image & image, const Image & maskImage, const Image & templateImage );

    private:

      /** Setup for member function dispatching */

      using MemberFunctionType = Image (Self::*)( const Image * image, const Image * maskImage, const Image * templateImage );
      template <class TImageType> Image ExecuteInternal ( const Image * image, const Image * maskImage, const Image * templateImage );


      friend struct detail::MemberFunctionAddressor<MemberFunctionType>;

      std::unique_ptr<detail::MemberFunctionFactory<MemberFunctionType> > m_MemberFactory;



    };

    /**\
     * \brief Computes the normalized correlation of an image and a template.
     *
     * This function directly calls the execute method of NormalizedCorrelationImageFilter
     * in order to support a procedural API
     *
     * \sa itk::simple::NormalizedCorrelationImageFilter for the object oriented interface
     * @{
     */

     SITKBasicFilters_EXPORT Image NormalizedCorrelation ( const Image & image, const Image & maskImage, const Image & templateImage );

     /** @} */
}
#endif
