/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.latex.tipa;

import com.dickimawbooks.texparserlib.Declaration;
import com.dickimawbooks.texparserlib.FontEncoding;
import com.dickimawbooks.texparserlib.TeXCsRef;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXSettings;
import com.dickimawbooks.texparserlib.latex.LaTeXParserListener;
import com.dickimawbooks.texparserlib.latex.fontenc.FontEncSty;
import java.io.IOException;

public class TipaEncoding
extends Declaration {
    private FontEncoding orgEncoding = null;

    public TipaEncoding() {
        this("tipaencoding");
    }

    public TipaEncoding(String string) {
        super(string);
    }

    @Override
    public Object clone() {
        return new TipaEncoding(this.getName());
    }

    @Override
    public TeXObjectList expandonce(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        return this.expandonce(teXParser);
    }

    @Override
    public TeXObjectList expandonce(TeXParser teXParser) throws IOException {
        TeXObjectList teXObjectList = new TeXObjectList();
        teXObjectList.add(new TeXCsRef("fontencoding"));
        teXObjectList.add(teXParser.getListener().createGroup("T3"));
        return teXObjectList;
    }

    @Override
    public TeXObjectList expandfully(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        return this.expandonce(teXParser);
    }

    @Override
    public TeXObjectList expandfully(TeXParser teXParser) throws IOException {
        return this.expandonce(teXParser);
    }

    @Override
    public void process(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        this.process(teXParser);
    }

    @Override
    public void process(TeXParser teXParser) throws IOException {
        TeXSettings teXSettings = teXParser.getSettings();
        this.orgEncoding = teXSettings.getCurrentFontEncoding();
        FontEncSty fontEncSty = ((LaTeXParserListener)teXParser.getListener()).getFontEncSty();
        FontEncoding fontEncoding = fontEncSty.getEncoding("T3");
        teXSettings.setFontEncoding(fontEncoding);
    }

    @Override
    public void end(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        TeXSettings teXSettings = teXParser.getSettings();
        teXSettings.setFontEncoding(this.orgEncoding);
    }

    @Override
    public boolean isModeSwitcher() {
        return false;
    }
}

