/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.url;

import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.util.Arrays;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.freeplane.core.extension.IExtension;
import org.freeplane.core.ui.components.JFreeplaneCustomizableFileChooser;
import org.freeplane.core.ui.components.PopupDialog;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.util.Compat;
import org.freeplane.core.util.FileUtils;
import org.freeplane.core.util.Hyperlink;
import org.freeplane.core.util.LogUtils;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.explorer.MapExplorerController;
import org.freeplane.features.map.DocuMapAttribute;
import org.freeplane.features.map.IMapSelectionListener;
import org.freeplane.features.map.MapController;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.MapWriter;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.url.FreeplaneUriConverter;
import org.freeplane.features.url.LastChoosenDirectory;
import org.freeplane.features.url.NodeAndMapReference;
import org.freeplane.n3.nanoxml.XMLException;
import org.freeplane.n3.nanoxml.XMLParseException;

public class UrlManager
implements IExtension {
    public static final String SMB_SCHEME = "smb";
    public static final String FREEPLANE_SCHEME = "freeplane";
    public static final String FILE_SCHEME = "file";
    public static final String FREEPLANE_FILE_EXTENSION_WITHOUT_DOT = "mm";
    public static final String FREEPLANE_FILE_EXTENSION = ".mm";
    public static final String FREEPLANE_ADD_ON_FILE_EXTENSION = ".addon.mm";
    private File lastCurrentDir = null;
    public static final String MAP_URL = "map_url";

    public static UrlManager getController() {
        ModeController modeController = Controller.getCurrentModeController();
        return modeController.getExtension(UrlManager.class);
    }

    public static void install(UrlManager urlManager) {
        ModeController modeController = Controller.getCurrentModeController();
        modeController.addExtension(UrlManager.class, urlManager);
        urlManager.init();
    }

    public static URI getAbsoluteUri(MapModel map, URI uri) throws MalformedURLException {
        if (uri == null || uri.isAbsolute()) {
            return uri;
        }
        if (uri.isOpaque()) {
            if (FILE_SCHEME.equals(uri.getScheme())) {
                try {
                    URL context = map.getURL();
                    if (context == null) {
                        return null;
                    }
                    URL resolvedUrl = new URL(context, uri.toString());
                    return URI.create(resolvedUrl.toString());
                }
                catch (IllegalArgumentException e) {
                    LogUtils.severe(e);
                    return null;
                }
            }
            return uri;
        }
        String path = uri.getPath();
        try {
            URL context = map.getURL();
            if (context == null) {
                return null;
            }
            URL url = new URL(context, path != null && path.isEmpty() ? "." : path);
            return new URI(url.getProtocol(), url.getHost(), url.getPath(), uri.getQuery(), uri.getFragment());
        }
        catch (URISyntaxException e) {
            LogUtils.severe(e);
            return null;
        }
    }

    public UrlManager() {
        Controller.getCurrentController().getMapViewManager().addMapSelectionListener(new IMapSelectionListener(){

            @Override
            public void afterMapChange(MapModel oldMap, MapModel newMap) {
                if (newMap != null) {
                    UrlManager.this.updateLastDirectoryFromMap(newMap);
                }
            }
        });
    }

    protected UrlManager(File file) {
        this();
        this.lastCurrentDir = file;
    }

    protected void init() {
        this.createActions();
    }

    private void createActions() {
    }

    public JFreeplaneCustomizableFileChooser getFileChooser() {
        final JFreeplaneCustomizableFileChooser choosery = this.getFileChooserNotFollowingDirectoryChanges();
        choosery.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                if (0L != (e.getChangeFlags() & 4L) && !choosery.isShowing()) {
                    UrlManager.this.setLastCurrentDir(choosery.getCurrentDirectory());
                }
            }
        });
        return choosery;
    }

    protected JFreeplaneCustomizableFileChooser getFileChooserNotFollowingDirectoryChanges() {
        JFreeplaneCustomizableFileChooser choosery = AccessController.doPrivileged(() -> {
            JFreeplaneCustomizableFileChooser chooser = new JFreeplaneCustomizableFileChooser(this.getLastCurrentDir());
            chooser.addCustomizer(PopupDialog::closeOnEscape);
            return chooser;
        });
        return choosery;
    }

    public JFreeplaneCustomizableFileChooser getFileChooser(FileFilter filter) {
        JFreeplaneCustomizableFileChooser chooser = this.getFileChooser();
        chooser.addChoosableFileFilter(filter);
        chooser.setFileFilter(filter);
        return chooser;
    }

    public File getLastCurrentDir() {
        this.updateLastDirectoryFromCurrentMap();
        return this.lastCurrentDir;
    }

    private void updateLastDirectoryFromCurrentMap() {
        MapModel map = Controller.getCurrentController().getMap();
        this.updateLastDirectoryFromMap(map);
    }

    private void updateLastDirectoryFromMap(MapModel map) {
        if (map == null || map.containsExtension(DocuMapAttribute.class)) {
            return;
        }
        File lastChoosenDir = LastChoosenDirectory.get(map);
        if (lastChoosenDir != null) {
            this.lastCurrentDir = lastChoosenDir;
        }
    }

    private void updateLastDirectory(MapModel map, File lastChoosenDir) {
        if (map == null || lastChoosenDir == null || map.containsExtension(DocuMapAttribute.class)) {
            return;
        }
        LastChoosenDirectory.set(map, lastChoosenDir);
    }

    public void handleLoadingException(Exception ex) {
        Throwable rootCause = ExceptionUtils.getRootCause((Throwable)ex);
        if (rootCause == null) {
            rootCause = ex;
        }
        String rootCauseMessage = ExceptionUtils.getMessage((Throwable)rootCause);
        String exceptionType = rootCause.getClass().getName();
        if (exceptionType.equals(XMLParseException.class.getName())) {
            int showDetail = JOptionPane.showConfirmDialog(Controller.getCurrentController().getMapViewManager().getMapViewComponent(), TextUtils.getText("map_corrupted"), "Freeplane", 0, 0);
            if (showDetail == 0) {
                UITools.errorMessage(rootCauseMessage);
            }
        } else if (exceptionType.equals(FileNotFoundException.class.getName())) {
            UITools.errorMessage(rootCauseMessage);
        } else {
            LogUtils.severe(ex);
            UITools.errorMessage(rootCauseMessage);
        }
    }

    public boolean loadCatchExceptions(URL url, MapModel map) {
        try {
            this.load(url, map);
            return true;
        }
        catch (XMLException ex) {
            LogUtils.warn(ex);
        }
        catch (IOException ex) {
            LogUtils.warn(ex);
        }
        catch (RuntimeException ex) {
            try {
                String urlString = url.toString();
                LogUtils.severe("Can not load url " + urlString, ex);
            }
            catch (Exception e) {
                LogUtils.severe("Can not load url", ex);
            }
        }
        UITools.errorMessage(TextUtils.format("url_open_error", url.toString()));
        return false;
    }

    public void load(URL url, MapModel map) throws IOException, XMLException {
        this.setURL(map, url);
        InputStream inputStream = this.getLocation(url).openStream();
        try (InputStreamReader urlStreamReader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);){
            ModeController modeController = Controller.getCurrentModeController();
            modeController.getMapController().getMapReader().createNodeTreeFromXml(map, (Reader)urlStreamReader, MapWriter.Mode.FILE);
        }
    }

    public URL getLocation(URL url) throws IOException {
        int responseCode;
        URLConnection connection = url.openConnection();
        if (connection instanceof HttpURLConnection && ((responseCode = ((HttpURLConnection)connection).getResponseCode()) == 302 || responseCode == 301 || responseCode == 303)) {
            String redirectUrl = connection.getHeaderField("Location");
            return this.getLocation(new URL(redirectUrl));
        }
        return url;
    }

    @Deprecated
    public void loadHyperlink(Hyperlink link) {
        String uriString = link.toString();
        if (uriString.startsWith("#")) {
            this.loadLocalLinkURI(uriString);
        } else {
            NodeAndMapReference nodeAndMapReference = new NodeAndMapReference(uriString);
            if (nodeAndMapReference.hasNodeReference()) {
                this.loadNodeReferenceURI(nodeAndMapReference);
            } else {
                this.loadOtherHyperlink(link, nodeAndMapReference.hasFreeplaneFileExtension());
            }
        }
    }

    private void loadLocalLinkURI(String uriString) {
        String target = uriString.substring(1);
        this.selectNode(null, target);
    }

    public void selectNode(NodeModel start, String localReference) {
        try {
            NodeModel node = Controller.getCurrentModeController().getExtension(MapExplorerController.class).getNodeAt(start, localReference);
            if (node != null) {
                MapController mapController = this.getMapController();
                mapController.select(node);
            } else {
                String errorMessage = TextUtils.format("link_not_found", localReference);
                Controller.getCurrentController().getViewController().err(errorMessage);
            }
        }
        catch (Exception e) {
            LogUtils.severe("link " + localReference + " not found", e);
        }
    }

    private void loadNodeReferenceURI(NodeAndMapReference nodeAndMapReference) {
        try {
            if (this.loadOtherHyperlink(new Hyperlink(new URI(nodeAndMapReference.getMapReference())), true)) {
                MapModel map = Controller.getCurrentController().getMap();
                this.selectNode(map.getRootNode(), nodeAndMapReference.getNodeReference());
            }
        }
        catch (URISyntaxException e) {
            LogUtils.severe(e);
        }
    }

    private boolean loadOtherHyperlink(Hyperlink link, boolean hasFreeplaneFileExtension) {
        URI uri = link.getUri();
        try {
            if (!uri.isAbsolute()) {
                URI absoluteUri = this.getAbsoluteUri(uri);
                if (absoluteUri == null) {
                    MapModel map = Controller.getCurrentController().getMap();
                    if (map.getURL() == null) {
                        UITools.errorMessage(TextUtils.getText("map_not_saved"));
                    } else {
                        UITools.errorMessage(TextUtils.format("link_not_found", String.valueOf(uri)));
                    }
                    return false;
                }
                uri = absoluteUri;
                link = new Hyperlink(absoluteUri);
            }
            if (!Arrays.asList(FILE_SCHEME, SMB_SCHEME, FREEPLANE_SCHEME).contains(uri.getScheme())) {
                try {
                    uri = uri.toURL().openConnection().getURL().toURI().normalize();
                }
                catch (Exception absoluteUri) {
                    // empty catch block
                }
            }
            try {
                if (hasFreeplaneFileExtension) {
                    FreeplaneUriConverter freeplaneUriConverter = new FreeplaneUriConverter();
                    URL url = freeplaneUriConverter.freeplaneUrl(uri);
                    ModeController modeController = Controller.getCurrentModeController();
                    modeController.getMapController().openMap(url);
                    return true;
                }
                Controller.getCurrentController().getViewController().openDocument(link);
            }
            catch (Exception e) {
                LogUtils.warn("link " + uri + " not found", e);
                UITools.errorMessage(TextUtils.format("link_not_found", uri.toString()));
            }
        }
        catch (MalformedURLException ex) {
            LogUtils.warn("URL " + uri + " not found", ex);
            UITools.errorMessage(TextUtils.format("link_not_found", uri));
        }
        return false;
    }

    private MapController getMapController() {
        ModeController modeController = Controller.getCurrentModeController();
        MapController mapController = modeController.getMapController();
        return mapController;
    }

    public void loadMap(String map) throws URISyntaxException {
        if (map.startsWith("freeplane:")) {
            String fixedUri = new FreeplaneUriConverter().fixPartiallyDecodedFreeplaneUriComingFromInternetExplorer(map);
            this.loadHyperlink(new Hyperlink(new URI(fixedUri)));
            return;
        }
        if (map.startsWith("http://") || map.startsWith("https://") || map.startsWith("file:")) {
            this.loadHyperlink(new Hyperlink(new URI(map)));
        } else {
            NodeAndMapReference nodeAndMapReference;
            if (!FileUtils.isAbsolutePath(map)) {
                map = System.getProperty("user.dir") + System.getProperty("file.separator") + map;
            }
            if ((nodeAndMapReference = new NodeAndMapReference(map)).hasFreeplaneFileExtension()) {
                URI uri = new File(nodeAndMapReference.getMapReference()).toURI();
                URI uriWithNodeReference = new URI(uri.getScheme(), null, uri.getPath(), nodeAndMapReference.getNodeReference());
                this.loadHyperlink(new Hyperlink(uriWithNodeReference));
            } else {
                LogUtils.warn("Invalid mind map file extension, not opened: " + map);
            }
        }
    }

    private URI getAbsoluteUri(URI uri) throws MalformedURLException {
        if (uri.isAbsolute()) {
            return uri;
        }
        MapModel map = Controller.getCurrentController().getMap();
        return UrlManager.getAbsoluteUri(map, uri);
    }

    private URI resolveWorkspaceRelatedUri(URI uri) {
        URI resolvedURI;
        try {
            resolvedURI = uri.toURL().openConnection().getURL().toURI();
        }
        catch (IOException ex) {
            LogUtils.severe(ex);
            return null;
        }
        catch (URISyntaxException ex) {
            LogUtils.severe(ex);
            return null;
        }
        catch (IllegalArgumentException ex) {
            resolvedURI = uri;
        }
        return resolvedURI;
    }

    public File getAbsoluteFile(MapModel map, URI uri) {
        if (uri == null) {
            return null;
        }
        try {
            URLConnection urlConnection = Compat.isWindowsOS() && uri.getScheme() != null && uri.getScheme().length() == 1 ? new File(uri.toString()).toURI().toURL().openConnection() : (uri.getScheme() == null && !uri.getPath().startsWith(File.separator) ? (map != null ? new File(uri.toString()).toURI().toURL().openConnection() : UrlManager.getAbsoluteUri(map, uri).toURL().openConnection()) : uri.toURL().openConnection());
            if (urlConnection == null) {
                return null;
            }
            URI absoluteUri = urlConnection.getURL().toURI().normalize();
            if (FILE_SCHEME.equalsIgnoreCase(absoluteUri.getScheme())) {
                return new File(absoluteUri);
            }
        }
        catch (URISyntaxException e) {
            LogUtils.warn(e);
        }
        catch (IOException e) {
            LogUtils.warn(e);
        }
        catch (Exception e) {
            LogUtils.warn(e);
        }
        return null;
    }

    public URL getAbsoluteUrl(MapModel map, URI uri) throws MalformedURLException {
        String fragment;
        String path = uri.isOpaque() ? uri.getSchemeSpecificPart() : uri.getPath();
        StringBuilder sb = new StringBuilder(path);
        String query = uri.getQuery();
        if (query != null) {
            sb.append('?');
            sb.append(query);
        }
        if ((fragment = uri.getFragment()) != null) {
            sb.append('#');
            sb.append(fragment);
        }
        if (!uri.isAbsolute() || uri.isOpaque() || uri.getScheme().length() > 0) {
            URL mapUrl = map.getURL();
            String scheme = uri.getScheme();
            if (scheme == null || mapUrl.getProtocol().equals(scheme)) {
                URL url = new URL(mapUrl, sb.toString());
                return url;
            }
        }
        URL url = new URL(uri.getScheme(), uri.getHost(), uri.getPort(), sb.toString());
        return url;
    }

    public URL getAbsoluteUrl(URI base, URI uri) throws MalformedURLException {
        String fragment;
        String path = uri.isOpaque() ? uri.getSchemeSpecificPart() : uri.getPath();
        StringBuilder sb = new StringBuilder(path);
        String query = uri.getQuery();
        if (query != null) {
            sb.append('?');
            sb.append(query);
        }
        if ((fragment = uri.getFragment()) != null) {
            sb.append('#');
            sb.append(fragment);
        }
        if (!uri.isAbsolute() || uri.isOpaque() || uri.getScheme().length() > 0) {
            URL baseUrl = base.toURL();
            String scheme = uri.getScheme();
            if (scheme == null || baseUrl.getProtocol().equals(scheme)) {
                URL url = new URL(baseUrl, sb.toString());
                return url;
            }
        }
        URL url = new URL(uri.getScheme(), uri.getHost(), uri.getPort(), sb.toString());
        return url;
    }

    private void setLastCurrentDir(File lastChoosenDir) {
        this.lastCurrentDir = lastChoosenDir;
        this.updateLastDirectory(Controller.getCurrentController().getMap(), lastChoosenDir);
    }

    protected void setURL(MapModel map, URL url) {
        map.setURL(url);
    }

    public File defaultTemplateFile() {
        return null;
    }

    public boolean save(MapModel map) {
        return false;
    }
}

