#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 incremental-parser
version:              0.5.1
visibility:           public
id:                   incremental-parser-0.5.1-I6mVHhfRzhhAlZa5iunlK
key:                  incremental-parser-0.5.1-I6mVHhfRzhhAlZa5iunlK
license:              GPL-3.0-only
copyright:            (c) 2011-2023 Mario Blazevic
maintainer:           blamario@yahoo.com
author:               Mario Blazevic
homepage:             https://github.com/blamario/incremental-parser
synopsis:
    Generic parser library capable of providing partial results from partial input.

description:
    This package defines yet another parser combinator library. This one is implemented using the concept of Brzozowski
    derivatives, tweaked and optimized to work with any monoidal input type. Lists, ByteString, and Text are supported out
    of the box, as well as any other data type for which the monoid-subclasses package defines instances. If the parser
    result is also a monoid, its chunks can be extracted incrementally, before the complete input is parsed.

category:             Parsing
abi:                  dd885594a8348ecc4f15789a33fa70b1
exposed:              True
exposed-modules:
    Control.Applicative.Monoid Text.ParserCombinators.Incremental
    Text.ParserCombinators.Incremental.LeftBiasedLocal
    Text.ParserCombinators.Incremental.Symmetric

import-dirs:          /usr/lib/ghc-9.4.8/site-local/incremental-parser-0.5.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/incremental-parser-0.5.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/incremental-parser-0.5.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-incremental-parser
hs-libraries:         HSincremental-parser-0.5.1-I6mVHhfRzhhAlZa5iunlK
depends:
    base-4.17.2.1 input-parsers-0.3.0.2-7XGjzVIHHt7IZs6Fc2Sbqv
    logict-0.8.1.0-Jdj6EXdmWVYDAwKtx31Ud2
    monoid-subclasses-1.2.6-3zJIBLK4ocv6wLAsI8Zfbl
    parsers-0.12.12-LrAtr2YQVMNBkASpTqmvwP
    rank2classes-1.5.4-GIzLhtW7AQLJ0tqTOrjD8z transformers-0.5.6.2

haddock-interfaces:
    /usr/share/doc/haskell-incremental-parser/html/incremental-parser.haddock

haddock-html:         /usr/share/doc/haskell-incremental-parser/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

