/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import org.apache.lucene.index.DocumentsWriterFlushControl;
import org.apache.lucene.index.DocumentsWriterPerThread;
import org.apache.lucene.index.LiveIndexWriterConfig;
import org.apache.lucene.util.InfoStream;

abstract class FlushPolicy {
    protected LiveIndexWriterConfig indexWriterConfig;
    protected InfoStream infoStream;

    FlushPolicy() {
    }

    public abstract void onChange(DocumentsWriterFlushControl var1, DocumentsWriterPerThread var2);

    protected synchronized void init(LiveIndexWriterConfig indexWriterConfig) {
        this.indexWriterConfig = indexWriterConfig;
        this.infoStream = indexWriterConfig.getInfoStream();
    }

    protected DocumentsWriterPerThread findLargestNonPendingWriter(DocumentsWriterFlushControl control, DocumentsWriterPerThread perThread) {
        assert (perThread.getNumDocsInRAM() > 0);
        DocumentsWriterPerThread maxRamUsingWriter = control.findLargestNonPendingWriter();
        assert (this.assertMessage("set largest ram consuming thread pending on lower watermark"));
        return maxRamUsingWriter;
    }

    private boolean assertMessage(String s) {
        if (this.infoStream.isEnabled("FP")) {
            this.infoStream.message("FP", s);
        }
        return true;
    }
}

