// Copyright Amazon.com Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
import { AlgorithmSuiteIdentifier } from '@aws-crypto/material-management';
const AES128_GCM_IV12_TAG16_NO_PADDING = AlgorithmSuiteIdentifier.ALG_AES128_GCM_IV12_TAG16;
const AES192_GCM_IV12_TAG16_NO_PADDING = AlgorithmSuiteIdentifier.ALG_AES192_GCM_IV12_TAG16;
const AES256_GCM_IV12_TAG16_NO_PADDING = AlgorithmSuiteIdentifier.ALG_AES256_GCM_IV12_TAG16;
export const RawAesWrappingSuiteIdentifier = Object.freeze({
    AES128_GCM_IV12_TAG16_NO_PADDING,
    AES192_GCM_IV12_TAG16_NO_PADDING,
    AES256_GCM_IV12_TAG16_NO_PADDING,
    // Adding reverse lookup to support checking supported suites
    [AES128_GCM_IV12_TAG16_NO_PADDING]: AES128_GCM_IV12_TAG16_NO_PADDING,
    [AES192_GCM_IV12_TAG16_NO_PADDING]: AES192_GCM_IV12_TAG16_NO_PADDING,
    [AES256_GCM_IV12_TAG16_NO_PADDING]: AES256_GCM_IV12_TAG16_NO_PADDING,
});
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicmF3X2Flc19hbGdvcml0aG1fc3VpdGUuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi8uLi9zcmMvcmF3X2Flc19hbGdvcml0aG1fc3VpdGUudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUEsb0VBQW9FO0FBQ3BFLHNDQUFzQztBQUV0QyxPQUFPLEVBQUUsd0JBQXdCLEVBQUUsTUFBTSxpQ0FBaUMsQ0FBQTtBQVkxRSxNQUFNLGdDQUFnQyxHQUNwQyx3QkFBd0IsQ0FBQyx5QkFBeUIsQ0FBQTtBQUNwRCxNQUFNLGdDQUFnQyxHQUNwQyx3QkFBd0IsQ0FBQyx5QkFBeUIsQ0FBQTtBQUNwRCxNQUFNLGdDQUFnQyxHQUNwQyx3QkFBd0IsQ0FBQyx5QkFBeUIsQ0FBQTtBQUNwRCxNQUFNLENBQUMsTUFBTSw2QkFBNkIsR0FFdEMsTUFBTSxDQUFDLE1BQU0sQ0FBQztJQUNoQixnQ0FBZ0M7SUFDaEMsZ0NBQWdDO0lBQ2hDLGdDQUFnQztJQUNoQyw2REFBNkQ7SUFDN0QsQ0FBQyxnQ0FBZ0MsQ0FBQyxFQUFFLGdDQUFnQztJQUNwRSxDQUFDLGdDQUFnQyxDQUFDLEVBQUUsZ0NBQWdDO0lBQ3BFLENBQUMsZ0NBQWdDLENBQUMsRUFBRSxnQ0FBZ0M7Q0FDckUsQ0FBQyxDQUFBIn0=