/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2Client;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.DescribeLaunchTemplatesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeLaunchTemplatesResponse;
import software.amazon.awssdk.services.ec2.model.LaunchTemplate;

public class DescribeLaunchTemplatesIterable
implements SdkIterable<DescribeLaunchTemplatesResponse> {
    private final Ec2Client client;
    private final DescribeLaunchTemplatesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeLaunchTemplatesIterable(Ec2Client client, DescribeLaunchTemplatesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeLaunchTemplatesResponseFetcher();
    }

    public Iterator<DescribeLaunchTemplatesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<LaunchTemplate> launchTemplates() {
        Function<DescribeLaunchTemplatesResponse, Iterator> getIterator = response -> {
            if (response != null && response.launchTemplates() != null) {
                return response.launchTemplates().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeLaunchTemplatesResponseFetcher
    implements SyncPageFetcher<DescribeLaunchTemplatesResponse> {
        private DescribeLaunchTemplatesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeLaunchTemplatesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeLaunchTemplatesResponse nextPage(DescribeLaunchTemplatesResponse previousPage) {
            if (previousPage == null) {
                return DescribeLaunchTemplatesIterable.this.client.describeLaunchTemplates(DescribeLaunchTemplatesIterable.this.firstRequest);
            }
            return DescribeLaunchTemplatesIterable.this.client.describeLaunchTemplates((DescribeLaunchTemplatesRequest)((Object)DescribeLaunchTemplatesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

