/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.processor.chunker;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import org.opensearch.neuralsearch.processor.chunker.Chunker;
import org.opensearch.neuralsearch.processor.chunker.DelimiterChunker;
import org.opensearch.neuralsearch.processor.chunker.FixedCharLengthChunker;
import org.opensearch.neuralsearch.processor.chunker.FixedTokenLengthChunker;

public final class ChunkerFactory {
    private static final Map<String, Function<Map<String, Object>, Chunker>> CHUNKERS_CONSTRUCTORS = ImmutableMap.of((Object)"fixed_token_length", FixedTokenLengthChunker::new, (Object)"delimiter", DelimiterChunker::new, (Object)"fixed_char_length", FixedCharLengthChunker::new);
    public static Set<String> CHUNKER_ALGORITHMS = CHUNKERS_CONSTRUCTORS.keySet();

    private ChunkerFactory() {
    }

    public static Chunker create(String type, Map<String, Object> parameters) {
        Function<Map<String, Object>, Chunker> chunkerConstructionFunction = CHUNKERS_CONSTRUCTORS.get(type);
        Objects.requireNonNull(chunkerConstructionFunction);
        return chunkerConstructionFunction.apply(parameters);
    }
}

