/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.search_pipeline;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch.search_pipeline.ResponseProcessor;
import org.opensearch.client.opensearch.search_pipeline.ResponseProcessorVariant;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class SortResponseProcessor
implements ResponseProcessorVariant,
PlainJsonSerializable,
ToCopyableBuilder<Builder, SortResponseProcessor> {
    @Nullable
    private final String description;
    @Nonnull
    private final String field;
    @Nullable
    private final Boolean ignoreFailure;
    @Nullable
    private final String order;
    @Nullable
    private final String tag;
    @Nullable
    private final String targetField;
    public static final JsonpDeserializer<SortResponseProcessor> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SortResponseProcessor::setupSortResponseProcessorDeserializer);

    private SortResponseProcessor(Builder builder) {
        this.description = builder.description;
        this.field = ApiTypeHelper.requireNonNull(builder.field, this, "field");
        this.ignoreFailure = builder.ignoreFailure;
        this.order = builder.order;
        this.tag = builder.tag;
        this.targetField = builder.targetField;
    }

    public static SortResponseProcessor of(Function<Builder, ObjectBuilder<SortResponseProcessor>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public ResponseProcessor.Kind _responseProcessorKind() {
        return ResponseProcessor.Kind.Sort;
    }

    @Nullable
    public final String description() {
        return this.description;
    }

    @Nonnull
    public final String field() {
        return this.field;
    }

    @Nullable
    public final Boolean ignoreFailure() {
        return this.ignoreFailure;
    }

    @Nullable
    public final String order() {
        return this.order;
    }

    @Nullable
    public final String tag() {
        return this.tag;
    }

    @Nullable
    public final String targetField() {
        return this.targetField;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.description != null) {
            generator.writeKey("description");
            generator.write(this.description);
        }
        generator.writeKey("field");
        generator.write(this.field);
        if (this.ignoreFailure != null) {
            generator.writeKey("ignore_failure");
            generator.write(this.ignoreFailure.booleanValue());
        }
        if (this.order != null) {
            generator.writeKey("order");
            generator.write(this.order);
        }
        if (this.tag != null) {
            generator.writeKey("tag");
            generator.write(this.tag);
        }
        if (this.targetField != null) {
            generator.writeKey("target_field");
            generator.write(this.targetField);
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupSortResponseProcessorDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::description, JsonpDeserializer.stringDeserializer(), "description");
        op.add(Builder::field, JsonpDeserializer.stringDeserializer(), "field");
        op.add(Builder::ignoreFailure, JsonpDeserializer.booleanDeserializer(), "ignore_failure");
        op.add(Builder::order, JsonpDeserializer.stringDeserializer(), "order");
        op.add(Builder::tag, JsonpDeserializer.stringDeserializer(), "tag");
        op.add(Builder::targetField, JsonpDeserializer.stringDeserializer(), "target_field");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.description);
        result = 31 * result + this.field.hashCode();
        result = 31 * result + Objects.hashCode(this.ignoreFailure);
        result = 31 * result + Objects.hashCode(this.order);
        result = 31 * result + Objects.hashCode(this.tag);
        result = 31 * result + Objects.hashCode(this.targetField);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SortResponseProcessor other = (SortResponseProcessor)o;
        return Objects.equals(this.description, other.description) && this.field.equals(other.field) && Objects.equals(this.ignoreFailure, other.ignoreFailure) && Objects.equals(this.order, other.order) && Objects.equals(this.tag, other.tag) && Objects.equals(this.targetField, other.targetField);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, SortResponseProcessor> {
        @Nullable
        private String description;
        private String field;
        @Nullable
        private Boolean ignoreFailure;
        @Nullable
        private String order;
        @Nullable
        private String tag;
        @Nullable
        private String targetField;

        public Builder() {
        }

        private Builder(SortResponseProcessor o) {
            this.description = o.description;
            this.field = o.field;
            this.ignoreFailure = o.ignoreFailure;
            this.order = o.order;
            this.tag = o.tag;
            this.targetField = o.targetField;
        }

        private Builder(Builder o) {
            this.description = o.description;
            this.field = o.field;
            this.ignoreFailure = o.ignoreFailure;
            this.order = o.order;
            this.tag = o.tag;
            this.targetField = o.targetField;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder description(@Nullable String value) {
            this.description = value;
            return this;
        }

        @Nonnull
        public final Builder field(String value) {
            this.field = value;
            return this;
        }

        @Nonnull
        public final Builder ignoreFailure(@Nullable Boolean value) {
            this.ignoreFailure = value;
            return this;
        }

        @Nonnull
        public final Builder order(@Nullable String value) {
            this.order = value;
            return this;
        }

        @Nonnull
        public final Builder tag(@Nullable String value) {
            this.tag = value;
            return this;
        }

        @Nonnull
        public final Builder targetField(@Nullable String value) {
            this.targetField = value;
            return this;
        }

        @Override
        @Nonnull
        public SortResponseProcessor build() {
            this._checkSingleUse();
            return new SortResponseProcessor(this);
        }
    }
}

