/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2AsyncClient;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.CapacityBlockOffering;
import software.amazon.awssdk.services.ec2.model.DescribeCapacityBlockOfferingsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeCapacityBlockOfferingsResponse;

public class DescribeCapacityBlockOfferingsPublisher
implements SdkPublisher<DescribeCapacityBlockOfferingsResponse> {
    private final Ec2AsyncClient client;
    private final DescribeCapacityBlockOfferingsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeCapacityBlockOfferingsPublisher(Ec2AsyncClient client, DescribeCapacityBlockOfferingsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeCapacityBlockOfferingsPublisher(Ec2AsyncClient client, DescribeCapacityBlockOfferingsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeCapacityBlockOfferingsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeCapacityBlockOfferingsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<CapacityBlockOffering> capacityBlockOfferings() {
        Function<DescribeCapacityBlockOfferingsResponse, Iterator> getIterator = response -> {
            if (response != null && response.capacityBlockOfferings() != null) {
                return response.capacityBlockOfferings().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeCapacityBlockOfferingsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeCapacityBlockOfferingsResponseFetcher
    implements AsyncPageFetcher<DescribeCapacityBlockOfferingsResponse> {
        private DescribeCapacityBlockOfferingsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeCapacityBlockOfferingsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeCapacityBlockOfferingsResponse> nextPage(DescribeCapacityBlockOfferingsResponse previousPage) {
            if (previousPage == null) {
                return DescribeCapacityBlockOfferingsPublisher.this.client.describeCapacityBlockOfferings(DescribeCapacityBlockOfferingsPublisher.this.firstRequest);
            }
            return DescribeCapacityBlockOfferingsPublisher.this.client.describeCapacityBlockOfferings((DescribeCapacityBlockOfferingsRequest)((Object)DescribeCapacityBlockOfferingsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

