/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2Client;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.CapacityReservationGroup;
import software.amazon.awssdk.services.ec2.model.GetGroupsForCapacityReservationRequest;
import software.amazon.awssdk.services.ec2.model.GetGroupsForCapacityReservationResponse;

public class GetGroupsForCapacityReservationIterable
implements SdkIterable<GetGroupsForCapacityReservationResponse> {
    private final Ec2Client client;
    private final GetGroupsForCapacityReservationRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetGroupsForCapacityReservationIterable(Ec2Client client, GetGroupsForCapacityReservationRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new GetGroupsForCapacityReservationResponseFetcher();
    }

    public Iterator<GetGroupsForCapacityReservationResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<CapacityReservationGroup> capacityReservationGroups() {
        Function<GetGroupsForCapacityReservationResponse, Iterator> getIterator = response -> {
            if (response != null && response.capacityReservationGroups() != null) {
                return response.capacityReservationGroups().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class GetGroupsForCapacityReservationResponseFetcher
    implements SyncPageFetcher<GetGroupsForCapacityReservationResponse> {
        private GetGroupsForCapacityReservationResponseFetcher() {
        }

        public boolean hasNextPage(GetGroupsForCapacityReservationResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetGroupsForCapacityReservationResponse nextPage(GetGroupsForCapacityReservationResponse previousPage) {
            if (previousPage == null) {
                return GetGroupsForCapacityReservationIterable.this.client.getGroupsForCapacityReservation(GetGroupsForCapacityReservationIterable.this.firstRequest);
            }
            return GetGroupsForCapacityReservationIterable.this.client.getGroupsForCapacityReservation((GetGroupsForCapacityReservationRequest)((Object)GetGroupsForCapacityReservationIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

