/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl.data.transformers;

import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBValueFormatting;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDAttributeTransformer;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.model.data.DBDValueHandler;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.impl.data.ProxyValueHandler;
import org.jkiss.dbeaver.model.impl.data.transformers.TransformerPresentationAttribute;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;

public class BooleanAttributeTransformer
implements DBDAttributeTransformer {
    private static final Log log = Log.getLog(BooleanAttributeTransformer.class);

    @Override
    public void transformAttribute(@NotNull DBCSession session, @NotNull DBDAttributeBinding attribute, @NotNull List<Object[]> rows, @NotNull Map<String, Object> options) throws DBException {
        attribute.setPresentationAttribute(new TransformerPresentationAttribute(attribute, "boolean", -1, DBPDataKind.BOOLEAN));
        attribute.setTransformHandler(new BooleanValueHandler(attribute.getValueHandler()));
    }

    private static class BooleanValueHandler
    extends ProxyValueHandler {
        BooleanValueHandler(DBDValueHandler target) {
            super(target);
        }

        @Override
        @NotNull
        public Class<?> getValueObjectType(@NotNull DBSTypedObject attribute) {
            return Boolean.class;
        }

        @Override
        public void bindValueObject(@NotNull DBCSession session, @NotNull DBCStatement statement, @NotNull DBSTypedObject type, int index, @Nullable Object value) throws DBCException {
            if (Boolean.TRUE.equals(value)) {
                value = 1;
            } else if (Boolean.FALSE.equals(value)) {
                value = 0;
            }
            super.bindValueObject(session, statement, type, index, value);
        }

        @Override
        @NotNull
        public String getValueDisplayString(@NotNull DBSTypedObject column, @Nullable Object value, @NotNull DBDDisplayFormat format) {
            if (value instanceof Number) {
                return Boolean.valueOf(((Number)value).byteValue() != 0).toString();
            }
            return DBValueFormatting.getDefaultValueDisplayString(value, format);
        }

        @Override
        @Nullable
        public Object getValueFromObject(@NotNull DBCSession session, @NotNull DBSTypedObject type, @Nullable Object object, boolean copy, boolean validateValue) throws DBCException {
            if (object instanceof Number) {
                if (((Number)object).byteValue() != 0) {
                    return true;
                }
                return false;
            }
            return super.getValueFromObject(session, type, object, copy, validateValue);
        }
    }
}

