/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.io.Serializable;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.EvaluatorException;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.IdFunctionObject;
import org.mozilla.javascript.IdScriptableObject;
import org.mozilla.javascript.NativeCallSite;
import org.mozilla.javascript.RhinoException;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.ScriptStackElement;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;

final class NativeError
extends IdScriptableObject {
    private static final long serialVersionUID = -5338413581437645187L;
    private static final Object ERROR_TAG = "Error";
    private static final String STACK_TAG = "stack";
    public static final int DEFAULT_STACK_LIMIT = -1;
    private static final String STACK_HIDE_KEY = "_stackHide";
    private RhinoException stackProvider;
    private Object stack;
    private static final int Id_constructor = 1;
    private static final int Id_toString = 2;
    private static final int Id_toSource = 3;
    private static final int ConstructorId_captureStackTrace = -1;
    private static final int MAX_PROTOTYPE_ID = 3;

    NativeError() {
    }

    static void init(Scriptable scriptable, boolean bl) {
        NativeError nativeError = new NativeError();
        ScriptableObject.putProperty((Scriptable)nativeError, "name", (Object)"Error");
        ScriptableObject.putProperty((Scriptable)nativeError, "message", (Object)"");
        ScriptableObject.putProperty((Scriptable)nativeError, "fileName", (Object)"");
        ScriptableObject.putProperty((Scriptable)nativeError, "lineNumber", (Object)0);
        nativeError.setAttributes("name", 2);
        nativeError.setAttributes("message", 2);
        nativeError.exportAsJSClass(3, scriptable, bl);
        NativeCallSite.init(nativeError, bl);
    }

    static NativeError make(Context context, Scriptable scriptable, IdFunctionObject idFunctionObject, Object[] objectArray) {
        Scriptable scriptable2 = (Scriptable)idFunctionObject.get("prototype", (Scriptable)idFunctionObject);
        NativeError nativeError = new NativeError();
        nativeError.setPrototype(scriptable2);
        nativeError.setParentScope(scriptable);
        int n = objectArray.length;
        if (n >= 1) {
            if (!Undefined.isUndefined(objectArray[0])) {
                ScriptableObject.putProperty((Scriptable)nativeError, "message", (Object)ScriptRuntime.toString(objectArray[0]));
                nativeError.setAttributes("message", 2);
            }
            if (n >= 2) {
                ScriptableObject.putProperty((Scriptable)nativeError, "fileName", objectArray[1]);
                if (n >= 3) {
                    int n2 = ScriptRuntime.toInt32(objectArray[2]);
                    ScriptableObject.putProperty((Scriptable)nativeError, "lineNumber", (Object)n2);
                }
            }
        }
        return nativeError;
    }

    @Override
    protected void fillConstructorProperties(IdFunctionObject idFunctionObject) {
        this.addIdFunctionProperty(idFunctionObject, ERROR_TAG, -1, "captureStackTrace", 2);
        this.stackProvider = new EvaluatorException("");
        ProtoProps protoProps = new ProtoProps();
        this.associateValue("_ErrorPrototypeProps", protoProps);
        idFunctionObject.defineProperty("stackTraceLimit", protoProps::getStackTraceLimit, protoProps::setStackTraceLimit, 0);
        idFunctionObject.defineProperty("prepareStackTrace", protoProps::getPrepareStackTrace, protoProps::setPrepareStackTrace, 0);
        super.fillConstructorProperties(idFunctionObject);
    }

    @Override
    public String getClassName() {
        return "Error";
    }

    public String toString() {
        Object object = NativeError.js_toString(this);
        return object instanceof String ? (String)object : super.toString();
    }

    @Override
    protected void initPrototypeId(int n) {
        String string;
        int n2;
        switch (n) {
            case 1: {
                n2 = 1;
                string = "constructor";
                break;
            }
            case 2: {
                n2 = 0;
                string = "toString";
                break;
            }
            case 3: {
                n2 = 0;
                string = "toSource";
                break;
            }
            default: {
                throw new IllegalArgumentException(String.valueOf(n));
            }
        }
        this.initPrototypeMethod(ERROR_TAG, n, string, n2);
    }

    @Override
    public Object execIdCall(IdFunctionObject idFunctionObject, Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        if (!idFunctionObject.hasTag(ERROR_TAG)) {
            return super.execIdCall(idFunctionObject, context, scriptable, scriptable2, objectArray);
        }
        int n = idFunctionObject.methodId();
        switch (n) {
            case 1: {
                NativeError nativeError = NativeError.make(context, scriptable, idFunctionObject, objectArray);
                nativeError.setStackProvider(new EvaluatorException(""));
                return nativeError;
            }
            case 2: {
                return NativeError.js_toString(scriptable2);
            }
            case 3: {
                return NativeError.js_toSource(context, scriptable, scriptable2);
            }
            case -1: {
                NativeError.js_captureStackTrace(context, scriptable, scriptable2, objectArray);
                return Undefined.instance;
            }
        }
        throw new IllegalArgumentException(String.valueOf(n));
    }

    public void setStackProvider(RhinoException rhinoException) {
        if (this.stackProvider == null) {
            this.defineProperty(STACK_TAG, this::getStackDelegated, this::setStackDelegated, 2);
        }
        this.stackProvider = rhinoException;
    }

    public Object getStackDelegated() {
        if (this.stack != null) {
            return this.stack;
        }
        if (this.stackProvider == null) {
            return NOT_FOUND;
        }
        int n = -1;
        Function function = null;
        NativeError nativeError = (NativeError)this.getPrototype();
        ProtoProps protoProps = (ProtoProps)nativeError.getAssociatedValue("_ErrorPrototypeProps");
        if (protoProps != null) {
            n = protoProps.stackTraceLimit;
            function = protoProps.prepareStackTrace;
        }
        String string = (String)this.getAssociatedValue(STACK_HIDE_KEY);
        ScriptStackElement[] scriptStackElementArray = this.stackProvider.getScriptStack(n, string);
        Object object = function == null ? RhinoException.formatStackTrace(scriptStackElementArray, this.stackProvider.details()) : this.callPrepareStack(function, scriptStackElementArray);
        this.stack = object;
        return object;
    }

    public void setStackDelegated(Object object) {
        this.stackProvider = null;
        this.stack = object;
    }

    private Object callPrepareStack(Function function, ScriptStackElement[] scriptStackElementArray) {
        Context context = Context.getCurrentContext();
        Object[] objectArray = new Object[scriptStackElementArray.length];
        for (int i = 0; i < scriptStackElementArray.length; ++i) {
            NativeCallSite nativeCallSite = (NativeCallSite)context.newObject(this, "CallSite");
            nativeCallSite.setElement(scriptStackElementArray[i]);
            objectArray[i] = nativeCallSite;
        }
        Scriptable scriptable = context.newArray((Scriptable)this, objectArray);
        return function.call(context, function, this, new Object[]{this, scriptable});
    }

    private static Object js_toString(Scriptable scriptable) {
        Object object = ScriptableObject.getProperty(scriptable, "name");
        String string = object == NOT_FOUND || Undefined.isUndefined(object) ? "Error" : ScriptRuntime.toString(object);
        Object object2 = ScriptableObject.getProperty(scriptable, "message");
        String string2 = object2 == NOT_FOUND || Undefined.isUndefined(object2) ? "" : ScriptRuntime.toString(object2);
        if (string.isEmpty()) {
            return string2;
        }
        if (string2.isEmpty()) {
            return string;
        }
        return string + ": " + string2;
    }

    private static String js_toSource(Context context, Scriptable scriptable, Scriptable scriptable2) {
        Object object = ScriptableObject.getProperty(scriptable2, "name");
        Object object2 = ScriptableObject.getProperty(scriptable2, "message");
        Object object3 = ScriptableObject.getProperty(scriptable2, "fileName");
        Object object4 = ScriptableObject.getProperty(scriptable2, "lineNumber");
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("(new ");
        if (object == NOT_FOUND) {
            object = Undefined.instance;
        }
        stringBuilder.append(ScriptRuntime.toString(object));
        stringBuilder.append("(");
        if (object2 != NOT_FOUND || object3 != NOT_FOUND || object4 != NOT_FOUND) {
            if (object2 == NOT_FOUND) {
                object2 = "";
            }
            stringBuilder.append(ScriptRuntime.uneval(context, scriptable, object2));
            if (object3 != NOT_FOUND || object4 != NOT_FOUND) {
                int n;
                stringBuilder.append(", ");
                if (object3 == NOT_FOUND) {
                    object3 = "";
                }
                stringBuilder.append(ScriptRuntime.uneval(context, scriptable, object3));
                if (object4 != NOT_FOUND && (n = ScriptRuntime.toInt32(object4)) != 0) {
                    stringBuilder.append(", ");
                    stringBuilder.append(ScriptRuntime.toString(n));
                }
            }
        }
        stringBuilder.append("))");
        return stringBuilder.toString();
    }

    private static void js_captureStackTrace(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        Object object;
        ScriptableObject scriptableObject = (ScriptableObject)ScriptRuntime.toObject(context, scriptable, objectArray[0]);
        Function function = null;
        if (objectArray.length > 1) {
            function = (Function)ScriptRuntime.toObjectOrNull(context, objectArray[1], scriptable);
        }
        NativeError nativeError = (NativeError)context.newObject(scriptable2, "Error");
        nativeError.setStackProvider(new EvaluatorException("[object Object]"));
        if (function != null && (object = function.get("name", (Scriptable)function)) != null && !Undefined.isUndefined(object)) {
            nativeError.associateValue(STACK_HIDE_KEY, Context.toString(object));
        }
        scriptableObject.defineProperty(STACK_TAG, nativeError.get(STACK_TAG), 2);
    }

    @Override
    protected int findPrototypeId(String string) {
        int n;
        switch (string) {
            case "constructor": {
                n = 1;
                break;
            }
            case "toString": {
                n = 2;
                break;
            }
            case "toSource": {
                n = 3;
                break;
            }
            default: {
                n = 0;
            }
        }
        return n;
    }

    private static final class ProtoProps
    implements Serializable {
        static final String KEY = "_ErrorPrototypeProps";
        private static final long serialVersionUID = 1907180507775337939L;
        int stackTraceLimit = -1;
        Function prepareStackTrace;

        private ProtoProps() {
        }

        public Object getStackTraceLimit() {
            if (this.stackTraceLimit >= 0) {
                return this.stackTraceLimit;
            }
            return Double.POSITIVE_INFINITY;
        }

        public void setStackTraceLimit(Object object) {
            double d = Context.toNumber(object);
            this.stackTraceLimit = Double.isNaN(d) || Double.isInfinite(d) ? -1 : (int)d;
        }

        public Object getPrepareStackTrace() {
            return this.prepareStackTrace == null ? Undefined.instance : this.prepareStackTrace;
        }

        public void setPrepareStackTrace(Object object) {
            if (object == null || Undefined.isUndefined(object)) {
                this.prepareStackTrace = null;
            } else if (object instanceof Function) {
                this.prepareStackTrace = (Function)object;
            }
        }
    }
}

