/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan.remote;

import java.lang.invoke.MethodHandles;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.util.concurrent.BlockingManager;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.connections.infinispan.InfinispanConnectionProvider;
import org.keycloak.infinispan.util.InfinispanUtils;
import org.keycloak.marshalling.Marshalling;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.KeycloakTransaction;
import org.keycloak.models.sessions.infinispan.InfinispanAuthenticationSessionProviderFactory;
import org.keycloak.models.sessions.infinispan.changes.remote.remover.query.ByRealmIdQueryConditionalRemover;
import org.keycloak.models.sessions.infinispan.changes.remote.updater.UpdaterFactory;
import org.keycloak.models.sessions.infinispan.changes.remote.updater.authsession.RootAuthenticationSessionUpdater;
import org.keycloak.models.sessions.infinispan.entities.RootAuthenticationSessionEntity;
import org.keycloak.models.sessions.infinispan.remote.RemoteInfinispanAuthenticationSessionProvider;
import org.keycloak.models.sessions.infinispan.remote.transaction.AuthenticationSessionChangeLogTransaction;
import org.keycloak.models.sessions.infinispan.remote.transaction.RemoteChangeLogTransaction;
import org.keycloak.provider.EnvironmentDependentProviderFactory;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.provider.ProviderConfigurationBuilder;
import org.keycloak.provider.ServerInfoAwareProviderFactory;
import org.keycloak.sessions.AuthenticationSessionProviderFactory;

public class RemoteInfinispanAuthenticationSessionProviderFactory
implements AuthenticationSessionProviderFactory<RemoteInfinispanAuthenticationSessionProvider>,
UpdaterFactory<String, RootAuthenticationSessionEntity, RootAuthenticationSessionUpdater>,
EnvironmentDependentProviderFactory,
RemoteChangeLogTransaction.SharedState<String, RootAuthenticationSessionEntity>,
ServerInfoAwareProviderFactory {
    private static final Logger logger = Logger.getLogger(MethodHandles.lookup().lookupClass());
    public static final String PROTO_ENTITY = Marshalling.protoEntity(RootAuthenticationSessionEntity.class);
    private int authSessionsLimit;
    private volatile RemoteCache<String, RootAuthenticationSessionEntity> cache;
    private volatile BlockingManager blockingManager;
    private volatile int maxRetries = 10;
    private volatile int backOffBaseTimeMillis = 10;

    public boolean isSupported(Config.Scope config) {
        return InfinispanUtils.isRemoteInfinispan();
    }

    public RemoteInfinispanAuthenticationSessionProvider create(KeycloakSession session) {
        return new RemoteInfinispanAuthenticationSessionProvider(session, this.authSessionsLimit, this.createAndEnlistTransaction(session));
    }

    public void init(Config.Scope config) {
        this.authSessionsLimit = InfinispanAuthenticationSessionProviderFactory.getAuthSessionsLimit(config);
        this.maxRetries = InfinispanUtils.getMaxRetries(config);
        this.backOffBaseTimeMillis = InfinispanUtils.getRetryBaseTimeMillis(config);
    }

    public void postInit(KeycloakSessionFactory factory) {
        try (KeycloakSession session = factory.create();){
            InfinispanConnectionProvider provider = (InfinispanConnectionProvider)session.getProvider(InfinispanConnectionProvider.class);
            this.cache = provider.getRemoteCache("authenticationSessions");
            this.blockingManager = provider.getBlockingManager();
            logger.debugf("Provided initialized. session limit=%s", this.authSessionsLimit);
        }
    }

    public void close() {
        this.cache = null;
    }

    public List<ProviderConfigProperty> getConfigMetadata() {
        ProviderConfigurationBuilder builder = ProviderConfigurationBuilder.create();
        InfinispanUtils.configureMaxRetries(builder);
        InfinispanUtils.configureRetryBaseTime(builder);
        return builder.property().name("authSessionsLimit").type("int").helpText("The maximum number of concurrent authentication sessions per RootAuthenticationSession.").defaultValue((Object)300).add().build();
    }

    public Map<String, String> getOperationalInfo() {
        HashMap<String, String> map = new HashMap<String, String>();
        InfinispanUtils.maxRetriesToOperationalInfo(map, this.maxRetries);
        InfinispanUtils.retryBaseTimeMillisToOperationalInfo(map, this.backOffBaseTimeMillis);
        return map;
    }

    @Override
    public RootAuthenticationSessionUpdater create(String key, RootAuthenticationSessionEntity entity) {
        return RootAuthenticationSessionUpdater.create(key, entity);
    }

    @Override
    public RootAuthenticationSessionUpdater wrapFromCache(String key, RootAuthenticationSessionEntity value, long version) {
        return RootAuthenticationSessionUpdater.wrap(key, value, version);
    }

    @Override
    public RootAuthenticationSessionUpdater deleted(String key) {
        return RootAuthenticationSessionUpdater.delete(key);
    }

    @Override
    public RemoteCache<String, RootAuthenticationSessionEntity> cache() {
        return this.cache;
    }

    public String getId() {
        return "remote";
    }

    public int order() {
        return 1;
    }

    private AuthenticationSessionChangeLogTransaction createAndEnlistTransaction(KeycloakSession session) {
        AuthenticationSessionChangeLogTransaction tx = new AuthenticationSessionChangeLogTransaction(this, this, new ByRealmIdQueryConditionalRemover<String, RootAuthenticationSessionEntity>(PROTO_ENTITY));
        session.getTransactionManager().enlistAfterCompletion((KeycloakTransaction)tx);
        return tx;
    }

    @Override
    public int maxRetries() {
        return this.maxRetries;
    }

    @Override
    public int backOffBaseTimeMillis() {
        return this.backOffBaseTimeMillis;
    }

    @Override
    public BlockingManager blockingManager() {
        return this.blockingManager;
    }
}

