/*
 * Decompiled with CFR 0.152.
 */
package net.adaptivebox.deps.behavior;

import net.adaptivebox.deps.behavior.AbsGTBehavior;
import net.adaptivebox.global.RandomGenerator;
import net.adaptivebox.goodness.IGoodnessCompareEngine;
import net.adaptivebox.knowledge.Library;
import net.adaptivebox.knowledge.SearchPoint;
import net.adaptivebox.problem.ProblemEncoder;
import net.adaptivebox.space.BasicPoint;
import net.adaptivebox.space.DesignSpace;

public class PSGTBehavior
extends AbsGTBehavior {
    public double c1 = 2.0;
    public double c2 = 2.0;
    public double weight = 0.4;
    public double CL = 0.0;
    private BasicPoint pold_t;
    private BasicPoint pcurrent_t;

    @Override
    public void setMemPoints(SearchPoint searchPoint, BasicPoint basicPoint, BasicPoint basicPoint2) {
        this.pcurrent_t = basicPoint;
        this.pbest_t = searchPoint;
        this.pold_t = basicPoint2;
    }

    @Override
    public void generateBehavior(SearchPoint searchPoint, ProblemEncoder problemEncoder) {
        DesignSpace designSpace = problemEncoder.getDesignSpace();
        double[] dArray = this.pold_t.getLocation();
        double[] dArray2 = this.pbest_t.getLocation();
        double[] dArray3 = this.pcurrent_t.getLocation();
        double[] dArray4 = this.socialLib.getGbest().getLocation();
        double[] dArray5 = searchPoint.getLocation();
        int n = designSpace.getDimension();
        for (int i = 0; i < n; ++i) {
            double d;
            if (RandomGenerator.doubleZeroOneRandom() < this.CL) {
                designSpace.mutationAt(dArray5, i);
                continue;
            }
            double d2 = this.weight * (dArray3[i] - dArray[i]) + this.c1 * RandomGenerator.doubleZeroOneRandom() * (dArray2[i] - dArray3[i]) + this.c2 * RandomGenerator.doubleZeroOneRandom() * (dArray4[i] - dArray3[i]);
            if (d2 < -(d = 0.5 * designSpace.getMagnitudeIn(i))) {
                d2 = -d;
            } else if (d2 > d) {
                d2 = d;
            }
            dArray5[i] = dArray3[i] + d2;
        }
    }

    @Override
    public void testBehavior(SearchPoint searchPoint, IGoodnessCompareEngine iGoodnessCompareEngine) {
        Library.replace(iGoodnessCompareEngine, searchPoint, this.pbest_t);
        this.pold_t.importLocation(this.pcurrent_t);
        this.pcurrent_t.importLocation(searchPoint);
    }
}

