/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.vcs.impl.frontend.shelf;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowManagerListener;
import com.intellij.platform.vcs.impl.frontend.shelf.ShelfToolWindowPanel;
import com.intellij.platform.vcs.impl.frontend.shelf.ShelfTreeUpdater;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.ui.content.impl.ToolWindowContentPostProcessor;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0001\u000eB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J \u0010\f\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\u000f"}, d2={"Lcom/intellij/platform/vcs/impl/frontend/shelf/ShelveContentReplacer;", "Lcom/intellij/ui/content/impl/ToolWindowContentPostProcessor;", "<init>", "()V", "isEnabled", "", "project", "Lcom/intellij/openapi/project/Project;", "content", "Lcom/intellij/ui/content/Content;", "toolWindow", "Lcom/intellij/openapi/wm/ToolWindow;", "postprocessContent", "", "ShelfTabListener", "intellij.platform.vcs.impl.frontend"})
@ApiStatus.Internal
public final class ShelveContentReplacer
implements ToolWindowContentPostProcessor {
    public boolean isEnabled(@NotNull Project project, @NotNull Content content, @NotNull ToolWindow toolWindow) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Intrinsics.checkNotNullParameter((Object)toolWindow, (String)"toolWindow");
        return Registry.Companion.is("vcs.shelves.rhizome.enabled") && Intrinsics.areEqual((Object)toolWindow.getId(), (Object)"Commit") && Intrinsics.areEqual((Object)content.getTabName(), (Object)"Shelf");
    }

    public void postprocessContent(@NotNull Project project, @NotNull Content content, @NotNull ToolWindow toolWindow) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Intrinsics.checkNotNullParameter((Object)toolWindow, (String)"toolWindow");
        ShelfTabListener listener = new ShelfTabListener(toolWindow);
        content.putUserData(ShelfTreeUpdater.Companion.getCONTENT_PROVIDER_SUPPLIER_KEY(), () -> ShelveContentReplacer.postprocessContent$lambda$0(project));
        toolWindow.getContentManager().addContentManagerListener((ContentManagerListener)listener);
    }

    private static final ShelfToolWindowPanel postprocessContent$lambda$0(Project $project) {
        return ShelfTreeUpdater.Companion.getInstance($project).createToolWindowPanel();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0013"}, d2={"Lcom/intellij/platform/vcs/impl/frontend/shelf/ShelveContentReplacer$ShelfTabListener;", "Lcom/intellij/ui/content/ContentManagerListener;", "Lcom/intellij/openapi/wm/ex/ToolWindowManagerListener;", "toolWindow", "Lcom/intellij/openapi/wm/ToolWindow;", "<init>", "(Lcom/intellij/openapi/wm/ToolWindow;)V", "getToolWindow", "()Lcom/intellij/openapi/wm/ToolWindow;", "stateChanged", "", "toolWindowManager", "Lcom/intellij/openapi/wm/ToolWindowManager;", "selectionChanged", "event", "Lcom/intellij/ui/content/ContentManagerEvent;", "initContent", "content", "Lcom/intellij/ui/content/Content;", "intellij.platform.vcs.impl.frontend"})
    public static final class ShelfTabListener
    implements ContentManagerListener,
    ToolWindowManagerListener {
        @NotNull
        private final ToolWindow toolWindow;

        public ShelfTabListener(@NotNull ToolWindow toolWindow) {
            Intrinsics.checkNotNullParameter((Object)toolWindow, (String)"toolWindow");
            this.toolWindow = toolWindow;
        }

        @NotNull
        public final ToolWindow getToolWindow() {
            return this.toolWindow;
        }

        public void stateChanged(@NotNull ToolWindowManager toolWindowManager) {
            Intrinsics.checkNotNullParameter((Object)toolWindowManager, (String)"toolWindowManager");
            Content selectedContent = this.toolWindow.getContentManager().getSelectedContent();
            if (this.toolWindow.isVisible()) {
                Content content = selectedContent;
                if (Intrinsics.areEqual((Object)"Shelf", (Object)(content != null ? content.getTabName() : null))) {
                    this.initContent(selectedContent);
                }
            }
        }

        public void selectionChanged(@NotNull ContentManagerEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            Content content = event.getContent();
            Intrinsics.checkNotNullExpressionValue((Object)content, (String)"getContent(...)");
            Content content2 = content;
            if (this.toolWindow.isVisible() && event.getOperation() == ContentManagerEvent.ContentOperation.add && Intrinsics.areEqual((Object)"Shelf", (Object)content2.getTabName())) {
                this.initContent(content2);
            }
        }

        private final void initContent(Content content) {
            Object object = (Function0)content.getUserData(ShelfTreeUpdater.Companion.getCONTENT_PROVIDER_SUPPLIER_KEY());
            if (object == null || (object = (ShelfToolWindowPanel)((Object)object.invoke())) == null) {
                return;
            }
            Object toolWindowPanel = object;
            content.putUserData(ShelfTreeUpdater.Companion.getCONTENT_PROVIDER_SUPPLIER_KEY(), null);
            content.setComponent((JComponent)toolWindowPanel);
        }
    }
}

