﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/ivs-realtime/IvsrealtimeRequest.h>
#include <aws/ivs-realtime/Ivsrealtime_EXPORTS.h>

#include <utility>

namespace Aws {
namespace ivsrealtime {
namespace Model {

/**
 */
class GetStageSessionRequest : public IvsrealtimeRequest {
 public:
  AWS_IVSREALTIME_API GetStageSessionRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "GetStageSession"; }

  AWS_IVSREALTIME_API Aws::String SerializePayload() const override;

  ///@{
  /**
   * <p>ARN of the stage for which the information is to be retrieved.</p>
   */
  inline const Aws::String& GetStageArn() const { return m_stageArn; }
  inline bool StageArnHasBeenSet() const { return m_stageArnHasBeenSet; }
  template <typename StageArnT = Aws::String>
  void SetStageArn(StageArnT&& value) {
    m_stageArnHasBeenSet = true;
    m_stageArn = std::forward<StageArnT>(value);
  }
  template <typename StageArnT = Aws::String>
  GetStageSessionRequest& WithStageArn(StageArnT&& value) {
    SetStageArn(std::forward<StageArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>ID of a session within the stage.</p>
   */
  inline const Aws::String& GetSessionId() const { return m_sessionId; }
  inline bool SessionIdHasBeenSet() const { return m_sessionIdHasBeenSet; }
  template <typename SessionIdT = Aws::String>
  void SetSessionId(SessionIdT&& value) {
    m_sessionIdHasBeenSet = true;
    m_sessionId = std::forward<SessionIdT>(value);
  }
  template <typename SessionIdT = Aws::String>
  GetStageSessionRequest& WithSessionId(SessionIdT&& value) {
    SetSessionId(std::forward<SessionIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_stageArn;

  Aws::String m_sessionId;
  bool m_stageArnHasBeenSet = false;
  bool m_sessionIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace ivsrealtime
}  // namespace Aws
