/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.widgets;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.openstreetmap.josm.data.preferences.NamedColorProperty;
import org.openstreetmap.josm.gui.util.ChangeNotifier;
import org.openstreetmap.josm.gui.widgets.JosmTextField;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;

public abstract class AbstractTextComponentValidator
extends ChangeNotifier
implements ActionListener,
FocusListener,
DocumentListener,
PropertyChangeListener {
    protected static final Color ERROR_COLOR = new NamedColorProperty(I18n.marktr("Input validation: error"), Color.RED).get();
    protected static final Border ERROR_BORDER = BorderFactory.createLineBorder(ERROR_COLOR, 1);
    protected static final Color ERROR_BACKGROUND = new NamedColorProperty(I18n.marktr("Input validation: error background"), new Color(0xFFCCCC)).get();
    protected static final Color WARNING_COLOR = new NamedColorProperty(I18n.marktr("Input validation: warning"), new Color(16753920)).get();
    protected static final Border WARNING_BORDER = BorderFactory.createLineBorder(WARNING_COLOR, 1);
    protected static final Color WARNING_FOREGROUND = new NamedColorProperty(I18n.marktr("Input validation: warning foreground"), Color.BLACK).get();
    protected static final Color WARNING_BACKGROUND = new NamedColorProperty(I18n.marktr("Input validation: warning background"), new Color(16772556)).get();
    protected static final Color VALID_COLOR = new NamedColorProperty(I18n.marktr("Input validation: valid"), new Color(32768)).get();
    protected static final Border VALID_BORDER = BorderFactory.createLineBorder(VALID_COLOR, 1);
    private final JTextComponent tc;
    private Status status;
    private String msg;

    protected void feedbackInvalid(String msg) {
        if (this.hasChanged(msg, Status.INVALID)) {
            this.feedback(ERROR_BORDER, ERROR_BACKGROUND, msg, Status.INVALID, msg);
        }
    }

    protected void feedbackWarning(String msg) {
        if (this.hasChanged(msg, Status.WARNING)) {
            this.feedback(WARNING_BORDER, WARNING_BACKGROUND, msg, Status.WARNING, msg);
        }
    }

    protected void feedbackDisabled() {
        this.feedbackValid(null);
    }

    protected void feedbackValid(String msg) {
        if (this.hasChanged(msg, Status.VALID)) {
            this.feedback(msg == null ? UIManager.getBorder("TextField.border") : VALID_BORDER, UIManager.getColor("TextField.background"), msg == null ? "" : msg, Status.VALID, msg);
        }
    }

    private boolean hasChanged(String msg, Status status) {
        return !Objects.equals((Object)status, (Object)this.status) || !Objects.equals(msg, this.msg);
    }

    private void feedback(Border border, Color background, String tooltip, Status status, String msg) {
        this.tc.setBorder(border);
        this.tc.setBackground(background);
        this.tc.setToolTipText(tooltip);
        this.status = status;
        this.msg = msg;
        this.fireStateChanged();
    }

    public JTextComponent getComponent() {
        return this.tc;
    }

    protected AbstractTextComponentValidator(JTextComponent tc) {
        this(tc, true);
    }

    protected AbstractTextComponentValidator(JTextComponent tc, boolean addActionListener) {
        this(tc, true, true, addActionListener);
    }

    protected AbstractTextComponentValidator(JTextComponent tc, boolean addFocusListener, boolean addDocumentListener, boolean addActionListener) {
        CheckParameterUtil.ensureParameterNotNull(tc, "tc");
        this.tc = tc;
        if (addFocusListener) {
            tc.addFocusListener(this);
        }
        if (addDocumentListener) {
            tc.getDocument().addDocumentListener(this);
        }
        if (addActionListener && tc instanceof JosmTextField) {
            ((JosmTextField)tc).addActionListener(this);
        }
        tc.addPropertyChangeListener("enabled", this);
    }

    public abstract void validate();

    public abstract boolean isValid();

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.validate();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.validate();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.validate();
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.validate();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.validate();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("enabled".equals(evt.getPropertyName())) {
            boolean enabled = (Boolean)evt.getNewValue();
            if (enabled) {
                this.validate();
            } else {
                this.feedbackDisabled();
            }
        }
    }

    static enum Status {
        INVALID,
        WARNING,
        VALID;

    }
}

