/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.auth.http.saml;

import java.nio.file.Path;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedActionException;
import java.time.Duration;
import net.shibboleth.shared.resolver.ResolverException;
import org.apache.hc.client5.http.classic.HttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManagerBuilder;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.socket.LayeredConnectionSocketFactory;
import org.opensaml.saml.metadata.resolver.impl.HTTPMetadataResolver;
import org.opensearch.SpecialPermission;
import org.opensearch.common.settings.Settings;
import org.opensearch.security.util.SettingsBasedSSLConfiguratorV4;

public class SamlHTTPMetadataResolver
extends HTTPMetadataResolver {
    SamlHTTPMetadataResolver(String idpMetadataUrl, Settings opensearchSettings, Path configPath) throws Exception {
        super(SamlHTTPMetadataResolver.createHttpClient(opensearchSettings, configPath), idpMetadataUrl);
        this.setMinRefreshDelay(Duration.ofMillis(opensearchSettings.getAsLong("idp.min_refresh_delay", Long.valueOf(60000L))));
        this.setMaxRefreshDelay(Duration.ofMillis(opensearchSettings.getAsLong("idp.max_refresh_delay", Long.valueOf(14400000L))));
        this.setRefreshDelayFactor(opensearchSettings.getAsFloat("idp.refresh_delay_factor", Float.valueOf(0.75f)).floatValue());
    }

    protected byte[] fetchMetadata() throws ResolverException {
        try {
            return AccessController.doPrivileged(() -> SamlHTTPMetadataResolver.super.fetchMetadata());
        }
        catch (PrivilegedActionException e) {
            if (e.getCause() instanceof ResolverException) {
                throw (ResolverException)e.getCause();
            }
            throw new RuntimeException(e);
        }
    }

    private static SettingsBasedSSLConfiguratorV4.SSLConfig getSSLConfig(Settings settings, Path configPath) throws Exception {
        return new SettingsBasedSSLConfiguratorV4(settings, configPath, "idp").buildSSLConfig();
    }

    private static HttpClient createHttpClient(Settings settings, Path configPath) throws Exception {
        try {
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                sm.checkPermission((Permission)new SpecialPermission());
            }
            return AccessController.doPrivileged(() -> SamlHTTPMetadataResolver.createHttpClient0(settings, configPath));
        }
        catch (PrivilegedActionException e) {
            if (e.getCause() instanceof Exception) {
                throw (Exception)e.getCause();
            }
            throw new RuntimeException(e);
        }
    }

    private static HttpClient createHttpClient0(Settings settings, Path configPath) throws Exception {
        HttpClientBuilder builder = HttpClients.custom();
        builder.useSystemProperties();
        SettingsBasedSSLConfiguratorV4.SSLConfig sslConfig = SamlHTTPMetadataResolver.getSSLConfig(settings, configPath);
        if (sslConfig != null) {
            builder.setConnectionManager((HttpClientConnectionManager)PoolingHttpClientConnectionManagerBuilder.create().setSSLSocketFactory((LayeredConnectionSocketFactory)sslConfig.toSSLConnectionSocketFactory5()).build());
        }
        return builder.build();
    }
}

