# Property3\[T1: T1, T2: T2, T3: T3\]
<span class="source-link">[[Source]](src/pony_check/property.md#L-0-129)</span>
```pony
trait ref Property3[T1: T1, T2: T2, T3: T3] is
  Property1[(T1 , T2 , T3)] ref
```

#### Implements

* [Property1](pony_check-Property1.md)\[(T1 , T2 , T3)\] ref

---

## Public Functions

### gen1
<span class="source-link">[[Source]](src/pony_check/property.md#L-0-131)</span>


The Generator for the first argument to your `property3` method.


```pony
fun box gen1()
: Generator[T1] box
```

#### Returns

* [Generator](pony_check-Generator.md)\[T1\] box

---

### gen2
<span class="source-link">[[Source]](src/pony_check/property.md#L-0-136)</span>


The Generator for the second argument to your `property3` method.


```pony
fun box gen2()
: Generator[T2] box
```

#### Returns

* [Generator](pony_check-Generator.md)\[T2\] box

---

### gen3
<span class="source-link">[[Source]](src/pony_check/property.md#L-0-141)</span>


The Generator for the third argument to your `property3` method.


```pony
fun box gen3()
: Generator[T3] box
```

#### Returns

* [Generator](pony_check-Generator.md)\[T3\] box

---

### gen
<span class="source-link">[[Source]](src/pony_check/property.md#L-0-146)</span>


```pony
fun box gen()
: Generator[(T1 , T2 , T3)] box
```

#### Returns

* [Generator](pony_check-Generator.md)\[(T1 , T2 , T3)\] box

---

### property
<span class="source-link">[[Source]](src/pony_check/property.md#L-0-152)</span>


```pony
fun ref property(
  arg1: (T1 , T2 , T3),
  h: PropertyHelper val)
: None val ?
```
#### Parameters

*   arg1: (T1 , T2 , T3)
*   h: [PropertyHelper](pony_check-PropertyHelper.md) val

#### Returns

* [None](builtin-None.md) val ?

---

### property3
<span class="source-link">[[Source]](src/pony_check/property.md#L-0-156)</span>


A method verifying that a certain property holds for all given
`arg1`,`arg2`, and `arg3`
with the help of [PropertyHelper](pony_check-PropertyHelper.md) `h`.


```pony
fun ref property3(
  arg1: T1,
  arg2: T2,
  arg3: T3,
  h: PropertyHelper val)
: None val ?
```
#### Parameters

*   arg1: T1
*   arg2: T2
*   arg3: T3
*   h: [PropertyHelper](pony_check-PropertyHelper.md) val

#### Returns

* [None](builtin-None.md) val ?

---

### name
<span class="source-link">[[Source]](src/pony_check/property.md#L-0-79)</span>


```pony
fun box name()
: String val
```

#### Returns

* [String](builtin-String.md) val

---

### params
<span class="source-link">[[Source]](src/pony_check/property.md#L-0-84)</span>


```pony
fun box params()
: PropertyParams val
```

#### Returns

* [PropertyParams](pony_check-PropertyParams.md) val

---

