/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.navigator.actions;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.menus.UIElement;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.fs.DBNFileSystemRoot;
import org.jkiss.dbeaver.model.navigator.fs.DBNPathBase;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.DialogUtils;
import org.jkiss.dbeaver.ui.navigator.NavigatorUtils;
import org.jkiss.utils.ByteNumberFormat;

public class NavigatorHandlerLoadResource
extends AbstractHandler
implements IElementUpdater {
    /*
     * WARNING - void declaration
     */
    public Object execute(ExecutionEvent event) throws ExecutionException {
        Shell shell = HandlerUtil.getActiveShell((ExecutionEvent)event);
        File[] srcFiles = DialogUtils.openFileList((Shell)shell, (String)"Open file(s)", null);
        if (srcFiles == null) {
            return null;
        }
        DBNNode pathNodes = NavigatorUtils.getSelectedNode(HandlerUtil.getCurrentSelection((ExecutionEvent)event));
        if (!(pathNodes instanceof DBNPathBase)) {
            return null;
        }
        DBNPathBase dBNPathBase = (DBNPathBase)pathNodes;
        try {
            void pathNode;
            UIUtils.runInProgressDialog(arg_0 -> this.lambda$0((DBNPathBase)pathNode, srcFiles, pathNodes, arg_0));
        }
        catch (Exception e) {
            DBWorkbench.getPlatformUI().showError("File save IO error", null, (Throwable)e);
        }
        return null;
    }

    private void loadLocalFiles(DBRProgressMonitor monitor, File[] srcFiles, Path targetPath) {
        File srcFile;
        long totalFilesSize = 0L;
        File[] fileArray = srcFiles;
        int n = srcFiles.length;
        int n2 = 0;
        while (n2 < n) {
            srcFile = fileArray[n2];
            totalFilesSize += srcFile.length();
            ++n2;
        }
        monitor.beginTask("Load resources", (int)totalFilesSize);
        fileArray = srcFiles;
        n = srcFiles.length;
        n2 = 0;
        while (n2 < n) {
            srcFile = fileArray[n2];
            if (monitor.isCanceled()) {
                return;
            }
            monitor.subTask(srcFile.getName() + " (" + ByteNumberFormat.getInstance().format(srcFile.length()) + ")");
            Path targetFilePath = targetPath.resolve(srcFile.getName());
            try {
                byte[] buffer = new byte[10000];
                Throwable throwable = null;
                Object var13_14 = null;
                try (InputStream is = Files.newInputStream(srcFile.toPath(), new OpenOption[0]);){
                    Throwable throwable2 = null;
                    Object var16_19 = null;
                    try (OutputStream os = Files.newOutputStream(targetFilePath, StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);){
                        while (!monitor.isCanceled()) {
                            int count = is.read(buffer);
                            if (count <= 0) {
                                break;
                            }
                            monitor.worked(count);
                            os.write(buffer, 0, count);
                        }
                    }
                    catch (Throwable throwable3) {
                        if (throwable2 == null) {
                            throwable2 = throwable3;
                        } else if (throwable2 != throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        throw throwable2;
                    }
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                DBWorkbench.getPlatformUI().showError("IO error", null, (Throwable)e);
            }
            ++n2;
        }
        monitor.done();
    }

    public void updateElement(UIElement element, Map parameters) {
    }

    private /* synthetic */ void lambda$0(DBNPathBase dBNPathBase, File[] fileArray, DBNNode dBNNode, DBRProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        try {
            Path targetPath = dBNPathBase.getPath();
            if (!(dBNPathBase instanceof DBNFileSystemRoot) && !Files.isDirectory(targetPath, new LinkOption[0])) {
                targetPath = targetPath.getParent();
            }
            this.loadLocalFiles(monitor, fileArray, targetPath);
            dBNNode.refreshNode(monitor, (Object)this);
        }
        catch (Exception e) {
            throw new InvocationTargetException(e);
        }
    }
}

