/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.cloud;

import java.awt.Color;
import java.io.IOException;
import org.freeplane.core.extension.IExtension;
import org.freeplane.core.io.IAttributeHandler;
import org.freeplane.core.io.IElementDOMHandler;
import org.freeplane.core.io.IElementWriter;
import org.freeplane.core.io.IExtensionElementWriter;
import org.freeplane.core.io.ITreeWriter;
import org.freeplane.core.io.ReadManager;
import org.freeplane.core.io.WriteManager;
import org.freeplane.core.util.ColorUtils;
import org.freeplane.features.cloud.CloudController;
import org.freeplane.features.cloud.CloudModel;
import org.freeplane.features.cloud.CloudShape;
import org.freeplane.features.map.MapController;
import org.freeplane.features.map.MapWriter;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.styles.LogicalStyleController;
import org.freeplane.n3.nanoxml.XMLElement;

class CloudBuilder
implements IElementDOMHandler,
IExtensionElementWriter,
IElementWriter {
    private final CloudController cc;

    public CloudBuilder(MapController mapController, CloudController cc) {
        this.cc = cc;
    }

    @Override
    public Object createElement(Object parent, String tag, XMLElement attributes) {
        if (tag.equals("cloud")) {
            CloudModel oldCloud = CloudModel.getModel((NodeModel)parent);
            return oldCloud != null ? oldCloud : new CloudModel();
        }
        return null;
    }

    @Override
    public void endElement(Object parent, String tag, Object userObject, XMLElement dom) {
        if (parent instanceof NodeModel) {
            NodeModel node = (NodeModel)parent;
            if (userObject instanceof CloudModel) {
                CloudModel cloud = (CloudModel)userObject;
                CloudModel.setModel(node, cloud);
            }
        }
    }

    private void registerAttributeHandlers(ReadManager reader) {
        reader.addAttributeHandler("cloud", "STYLE", new IAttributeHandler(){

            @Override
            public void setAttribute(Object userObject, String value) {
            }
        });
        reader.addAttributeHandler("cloud", "COLOR", new IAttributeHandler(){

            @Override
            public void setAttribute(Object userObject, String value) {
                CloudModel cloud = (CloudModel)userObject;
                cloud.setColor(ColorUtils.stringToColor(value, cloud.getColor()));
            }
        });
        reader.addAttributeHandler("cloud", "ALPHA", new IAttributeHandler(){

            @Override
            public void setAttribute(Object userObject, String value) {
                CloudModel cloud = (CloudModel)userObject;
                cloud.setColor(ColorUtils.alphaToColor(value, cloud.getColor()));
            }
        });
        reader.addAttributeHandler("cloud", "SHAPE", new IAttributeHandler(){

            @Override
            public void setAttribute(Object userObject, String value) {
                CloudModel cloud = (CloudModel)userObject;
                cloud.setShape(CloudShape.valueOf(value));
            }
        });
        reader.addAttributeHandler("cloud", "WIDTH", new IAttributeHandler(){

            @Override
            public void setAttribute(Object userObject, String value) {
            }
        });
    }

    public void registerBy(ReadManager reader, WriteManager writer) {
        reader.addElementHandler("cloud", this);
        this.registerAttributeHandlers(reader);
        writer.addExtensionElementWriter(CloudModel.class, this);
        writer.addElementWriter("node", this);
        writer.addElementWriter("stylenode", this);
    }

    public void setAttributes(String tag, Object node, XMLElement attributes) {
    }

    @Override
    public void writeContent(ITreeWriter writer, Object userObject, String tag) throws IOException {
        boolean forceFormatting = Boolean.TRUE.equals(writer.getHint((Object)MapWriter.WriterHint.FORCE_FORMATTING));
        if (!forceFormatting) {
            return;
        }
        this.writeContentImpl(writer, (NodeModel)userObject, null);
    }

    @Override
    public void writeContent(ITreeWriter writer, Object userObject, IExtension extension) throws IOException {
        boolean forceFormatting = Boolean.TRUE.equals(writer.getHint((Object)MapWriter.WriterHint.FORCE_FORMATTING));
        if (forceFormatting) {
            return;
        }
        this.writeContentImpl(writer, null, extension);
    }

    private void writeContentImpl(ITreeWriter writer, NodeModel node, IExtension extension) throws IOException {
        CloudShape shape;
        CloudModel model;
        CloudModel cloudModel = model = extension != null ? (CloudModel)extension : this.cc.getCloud(node, LogicalStyleController.StyleOption.FOR_UNSELECTED_NODE);
        if (model == null) {
            return;
        }
        XMLElement cloud = new XMLElement();
        cloud.setName("cloud");
        Color color = model.getColor();
        if (color != null) {
            ColorUtils.setColorAttributes(cloud, "COLOR", "ALPHA", color);
        }
        if ((shape = model.getShape()) != null) {
            cloud.setAttribute("SHAPE", shape.toString());
        }
        writer.addElement((Object)model, cloud);
    }
}

