/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3.auxiliary.remote;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.jcs3.log.Log;
import org.apache.commons.jcs3.log.LogManager;

public final class RemoteLocation {
    private static final Log log = LogManager.getLog(RemoteLocation.class);
    private static final Pattern SERVER_COLON_PORT = Pattern.compile("(\\S+)\\s*:\\s*(\\d+)");
    private final String host;
    private final int port;

    public RemoteLocation(String host, int port) {
        this.host = host;
        this.port = port;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof RemoteLocation)) {
            return false;
        }
        RemoteLocation l = (RemoteLocation)obj;
        if (this.host == null) {
            return l.host == null && this.port == l.port;
        }
        return this.host.equals(l.host) && this.port == l.port;
    }

    public int hashCode() {
        return this.host == null ? this.port : this.host.hashCode() ^ this.port;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.host != null) {
            sb.append(this.host);
        }
        sb.append(':').append(this.port);
        return sb.toString();
    }

    public static RemoteLocation parseServerAndPort(String server) {
        Matcher match = SERVER_COLON_PORT.matcher(server);
        if (match.find() && match.groupCount() == 2) {
            return new RemoteLocation(match.group(1), Integer.parseInt(match.group(2)));
        }
        log.error("Invalid server descriptor: {0}", server);
        return null;
    }
}

