/************************************************************************
 * This program is free software; you can redistribute it and/or modify *
 * it under the terms of the GNU General Public License as published by *
 * the Free Software Foundation; either version 2 of the License, or    *
 * (at your option) any later version.                                  *
 *                                                                      *
 * This program is distributed in the hope that it will be useful,      *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 * GNU General Public License for more details.                         *
 *                                                                      *
 * You should have received a copy of the GNU General Public License    *
 * along with this program; if not, write to the                        *
 * Free Software Foundation, Inc.,                                      *
 * 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA.             *
 ************************************************************************/

#ifndef __FCITX_MODULE_FCITX_X11_API_H
#define __FCITX_MODULE_FCITX_X11_API_H

#ifdef FCITX_DISABLE_X11
#  undef FCITX_DISABLE_X11
#endif
#include <stdint.h>
#include <stdarg.h>
#include <fcitx-utils/utils.h>
#include <fcitx/instance.h>
#include <fcitx/addon.h>
#include <fcitx/module.h>
#include "x11stuff.h"

#ifdef __cplusplus
extern "C" {
#endif

DEFINE_GET_ADDON("fcitx-x11", X11)

DEFINE_GET_AND_INVOKE_FUNC(X11, GetDisplay, 0)
static inline Display*
FcitxX11GetDisplay(FcitxInstance *instance)
{
    static FcitxInstance *_instance = NULL;
    static void *result = NULL;
    if (fcitx_likely(_instance == instance))
        FCITX_RETURN_FROM_PTR(Display*, result);
    _instance = instance;
    FCITX_DEF_MODULE_ARGS(args);
    result = FcitxX11InvokeGetDisplay(instance, args);
    FCITX_RETURN_FROM_PTR(Display*, result);
}

DEFINE_GET_AND_INVOKE_FUNC(X11, AddXEventHandler, 1)
static inline void
FcitxX11AddXEventHandler(FcitxInstance *instance, FcitxX11XEventHandler _arg0, void* _arg1)
{
    FCITX_DEF_CAST_TO_PTR(arg0, FcitxX11XEventHandler, _arg0);
    FCITX_DEF_CAST_TO_PTR(arg1, void*, _arg1);
    FCITX_DEF_MODULE_ARGS(args, arg0, arg1);
    FcitxX11InvokeAddXEventHandler(instance, args);
}

DEFINE_GET_AND_INVOKE_FUNC(X11, RemoveXEventHandler, 2)
static inline void
FcitxX11RemoveXEventHandler(FcitxInstance *instance, void* _arg0)
{
    FCITX_DEF_CAST_TO_PTR(arg0, void*, _arg0);
    FCITX_DEF_MODULE_ARGS(args, arg0);
    FcitxX11InvokeRemoveXEventHandler(instance, args);
}

DEFINE_GET_AND_INVOKE_FUNC(X11, FindARGBVisual, 3)
static inline Visual*
FcitxX11FindARGBVisual(FcitxInstance *instance)
{
    void *result = NULL;
    FCITX_DEF_MODULE_ARGS(args);
    result = FcitxX11InvokeFindARGBVisual(instance, args);
    FCITX_RETURN_FROM_PTR(Visual*, result);
}

DEFINE_GET_AND_INVOKE_FUNC(X11, InitWindowAttribute, 4)
static inline void
FcitxX11InitWindowAttribute(FcitxInstance *instance, Visual** _arg0, Colormap* _arg1, XSetWindowAttributes* _arg2, unsigned long* _arg3, int* _arg4)
{
    FCITX_DEF_CAST_TO_PTR(arg0, Visual**, _arg0);
    FCITX_DEF_CAST_TO_PTR(arg1, Colormap*, _arg1);
    FCITX_DEF_CAST_TO_PTR(arg2, XSetWindowAttributes*, _arg2);
    FCITX_DEF_CAST_TO_PTR(arg3, unsigned long*, _arg3);
    FCITX_DEF_CAST_TO_PTR(arg4, int*, _arg4);
    FCITX_DEF_MODULE_ARGS(args, arg0, arg1, arg2, arg3, arg4);
    FcitxX11InvokeInitWindowAttribute(instance, args);
}

DEFINE_GET_AND_INVOKE_FUNC(X11, SetWindowProp, 5)
static inline void
FcitxX11SetWindowProp(FcitxInstance *instance, const Window* _arg0, const FcitxXWindowType* _arg1, char* _arg2)
{
    FCITX_DEF_CAST_TO_PTR(arg0, const Window*, _arg0);
    FCITX_DEF_CAST_TO_PTR(arg1, const FcitxXWindowType*, _arg1);
    FCITX_DEF_CAST_TO_PTR(arg2, char*, _arg2);
    FCITX_DEF_MODULE_ARGS(args, arg0, arg1, arg2);
    FcitxX11InvokeSetWindowProp(instance, args);
}

DEFINE_GET_AND_INVOKE_FUNC(X11, GetScreenSize, 6)
static inline void
FcitxX11GetScreenSize(FcitxInstance *instance, int* _arg0, int* _arg1)
{
    FCITX_DEF_CAST_TO_PTR(arg0, int*, _arg0);
    FCITX_DEF_CAST_TO_PTR(arg1, int*, _arg1);
    FCITX_DEF_MODULE_ARGS(args, arg0, arg1);
    FcitxX11InvokeGetScreenSize(instance, args);
}

DEFINE_GET_AND_INVOKE_FUNC(X11, MouseClick, 7)
static inline void
FcitxX11MouseClick(FcitxInstance *instance, const Window* _arg0, int* _arg1, int* _arg2, boolean* _arg3)
{
    FCITX_DEF_CAST_TO_PTR(arg0, const Window*, _arg0);
    FCITX_DEF_CAST_TO_PTR(arg1, int*, _arg1);
    FCITX_DEF_CAST_TO_PTR(arg2, int*, _arg2);
    FCITX_DEF_CAST_TO_PTR(arg3, boolean*, _arg3);
    FCITX_DEF_MODULE_ARGS(args, arg0, arg1, arg2, arg3);
    FcitxX11InvokeMouseClick(instance, args);
}

DEFINE_GET_AND_INVOKE_FUNC(X11, AddCompositeHandler, 8)
static inline void
FcitxX11AddCompositeHandler(FcitxInstance *instance, FcitxX11CompositeHandler _arg0, void* _arg1)
{
    FCITX_DEF_CAST_TO_PTR(arg0, FcitxX11CompositeHandler, _arg0);
    FCITX_DEF_CAST_TO_PTR(arg1, void*, _arg1);
    FCITX_DEF_MODULE_ARGS(args, arg0, arg1);
    FcitxX11InvokeAddCompositeHandler(instance, args);
}

DEFINE_GET_AND_INVOKE_FUNC(X11, GetScreenGeometry, 9)
static inline void
FcitxX11GetScreenGeometry(FcitxInstance *instance, const int* _arg0, const int* _arg1, FcitxRect* _arg2)
{
    FCITX_DEF_CAST_TO_PTR(arg0, const int*, _arg0);
    FCITX_DEF_CAST_TO_PTR(arg1, const int*, _arg1);
    FCITX_DEF_CAST_TO_PTR(arg2, FcitxRect*, _arg2);
    FCITX_DEF_MODULE_ARGS(args, arg0, arg1, arg2);
    FcitxX11InvokeGetScreenGeometry(instance, args);
}

DEFINE_GET_AND_INVOKE_FUNC(X11, ProcessRemainEvent, 10)
static inline void
FcitxX11ProcessRemainEvent(FcitxInstance *instance)
{
    FCITX_DEF_MODULE_ARGS(args);
    FcitxX11InvokeProcessRemainEvent(instance, args);
}

DEFINE_GET_AND_INVOKE_FUNC(X11, GetDPI, 11)
static inline void
FcitxX11GetDPI(FcitxInstance *instance, int* _arg0, double* _arg1)
{
    FCITX_DEF_CAST_TO_PTR(arg0, int*, _arg0);
    FCITX_DEF_CAST_TO_PTR(arg1, double*, _arg1);
    FCITX_DEF_MODULE_ARGS(args, arg0, arg1);
    FcitxX11InvokeGetDPI(instance, args);
}

DEFINE_GET_AND_INVOKE_FUNC(X11, RegSelectNotify, 12)
static inline int
FcitxX11RegSelectNotify(FcitxInstance *instance, const char* _arg0, void* _arg1, X11SelectionNotifyCallback _arg2, void* _arg3, FcitxDestroyNotify _arg4)
{
    void *result = NULL;
    FCITX_DEF_CAST_TO_PTR(arg0, const char*, _arg0);
    FCITX_DEF_CAST_TO_PTR(arg1, void*, _arg1);
    FCITX_DEF_CAST_TO_PTR(arg2, X11SelectionNotifyCallback, _arg2);
    FCITX_DEF_CAST_TO_PTR(arg3, void*, _arg3);
    FCITX_DEF_CAST_TO_PTR(arg4, FcitxDestroyNotify, _arg4);
    FCITX_DEF_MODULE_ARGS(args, arg0, arg1, arg2, arg3, arg4);
    result = FcitxX11InvokeRegSelectNotify(instance, args);
    FCITX_RETURN_FROM_PTR(int, result);
}

DEFINE_GET_AND_INVOKE_FUNC(X11, RemoveSelectNotify, 13)
static inline void
FcitxX11RemoveSelectNotify(FcitxInstance *instance, int _arg0)
{
    FCITX_DEF_CAST_TO_PTR(arg0, int, _arg0);
    FCITX_DEF_MODULE_ARGS(args, arg0);
    FcitxX11InvokeRemoveSelectNotify(instance, args);
}

DEFINE_GET_AND_INVOKE_FUNC(X11, DefaultEventWindow, 14)
static inline Window
FcitxX11DefaultEventWindow(FcitxInstance *instance)
{
    static FcitxInstance *_instance = NULL;
    static void *result = NULL;
    if (fcitx_likely(_instance == instance))
        FCITX_RETURN_FROM_PTR(Window, result);
    _instance = instance;
    FCITX_DEF_MODULE_ARGS(args);
    result = FcitxX11InvokeDefaultEventWindow(instance, args);
    FCITX_RETURN_FROM_PTR(Window, result);
}

DEFINE_GET_AND_INVOKE_FUNC(X11, RequestConvertSelect, 15)
static inline int
FcitxX11RequestConvertSelect(FcitxInstance *instance, const char* _arg0, const char* _arg1, void* _arg2, X11ConvertSelectionCallback _arg3, void* _arg4, FcitxDestroyNotify _arg5)
{
    void *result = NULL;
    FCITX_DEF_CAST_TO_PTR(arg0, const char*, _arg0);
    FCITX_DEF_CAST_TO_PTR(arg1, const char*, _arg1);
    FCITX_DEF_CAST_TO_PTR(arg2, void*, _arg2);
    FCITX_DEF_CAST_TO_PTR(arg3, X11ConvertSelectionCallback, _arg3);
    FCITX_DEF_CAST_TO_PTR(arg4, void*, _arg4);
    FCITX_DEF_CAST_TO_PTR(arg5, FcitxDestroyNotify, _arg5);
    FCITX_DEF_MODULE_ARGS(args, arg0, arg1, arg2, arg3, arg4, arg5);
    result = FcitxX11InvokeRequestConvertSelect(instance, args);
    FCITX_RETURN_FROM_PTR(int, result);
}

DEFINE_GET_AND_INVOKE_FUNC(X11, RemoveCompositeHandler, 16)
static inline void
FcitxX11RemoveCompositeHandler(FcitxInstance *instance, void* _arg0)
{
    FCITX_DEF_CAST_TO_PTR(arg0, void*, _arg0);
    FCITX_DEF_MODULE_ARGS(args, arg0);
    FcitxX11InvokeRemoveCompositeHandler(instance, args);
}


#ifdef __cplusplus
}
#endif

#endif
